/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.client.model;

import com.google.common.collect.ImmutableSet;
import javax.annotation.Nonnull;
import mysticmods.mysticalworld.entity.SilverFoxEntity;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;

public class SilverFoxModel
extends AgeableListModel<SilverFoxEntity> {
    private final ModelPart body1;
    private final ModelPart frontL;
    private final ModelPart frontR;
    private final ModelPart body2;
    private final ModelPart neck;
    private final ModelPart backL;
    private final ModelPart backR;
    private final ModelPart tail1;
    private final ModelPart tail2;
    private final ModelPart tail3;
    private final ModelPart tail4;
    private final ModelPart head;
    private final ModelPart snout;
    private final ModelPart earR;
    private final ModelPart earL;

    public SilverFoxModel(ModelPart pRoot) {
        super(true, 5.0f, 2.0f);
        this.body1 = pRoot.m_171324_("body1");
        this.neck = this.body1.m_171324_("neck");
        this.head = this.neck.m_171324_("head");
        this.earR = this.head.m_171324_("ear_right");
        this.earL = this.head.m_171324_("ear_left");
        this.snout = this.head.m_171324_("snout");
        this.frontL = this.body1.m_171324_("front_left_leg");
        this.frontR = this.body1.m_171324_("front_right_leg");
        this.body2 = this.body1.m_171324_("body2");
        this.backL = this.body2.m_171324_("back_left_leg");
        this.backR = this.body2.m_171324_("back_right_leg");
        this.tail1 = this.body2.m_171324_("tail1");
        this.tail2 = this.tail1.m_171324_("tail2");
        this.tail3 = this.tail2.m_171324_("tail3");
        this.tail4 = this.tail3.m_171324_("tail4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body1 = partdefinition.m_171599_("body1", CubeListBuilder.m_171558_().m_171514_(12, 8).m_171481_(-2.5f, 0.0f, 0.0f, 5.0f, 4.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)15.5f, (float)-2.0f));
        PartDefinition neck = body1.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(-2.0f, -2.0f, -4.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)1.5f, (float)2.0f, (float)-0.2617994f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171481_(-2.5f, -2.0f, -3.0f, 5.0f, 4.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-4.0f, (float)0.2617994f, (float)0.0f, (float)0.0f));
        CubeListBuilder earCubeList = CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-1.0f, -3.0f, -0.5f, 2.0f, 3.0f, 1.0f);
        PartDefinition earR = head.m_171599_("ear_right", earCubeList, PartPose.m_171423_((float)-1.5f, (float)-1.0f, (float)-1.0f, (float)0.0f, (float)0.2617994f, (float)-0.5235988f));
        PartDefinition earL = head.m_171599_("ear_left", earCubeList.m_171480_(), PartPose.m_171423_((float)1.5f, (float)-1.0f, (float)-1.0f, (float)0.0f, (float)-0.2617994f, (float)0.5235988f));
        PartDefinition snout = head.m_171599_("snout", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.5f, 0.0f, -3.0f, 3.0f, 2.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-3.0f, (float)0.17453292f, (float)0.0f, (float)0.0f));
        CubeListBuilder legCubeList = CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f);
        PartDefinition frontL = body1.m_171599_("front_left_leg", legCubeList.m_171480_(), PartPose.m_171419_((float)1.0f, (float)4.0f, (float)1.0f));
        PartDefinition frontR = body1.m_171599_("front_right_leg", legCubeList, PartPose.m_171419_((float)-1.0f, (float)4.0f, (float)1.0f));
        PartDefinition body2 = body1.m_171599_("body2", CubeListBuilder.m_171558_().m_171514_(16, 17).m_171481_(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)5.0f));
        PartDefinition backL = body2.m_171599_("back_left_leg", legCubeList.m_171480_(), PartPose.m_171419_((float)1.0f, (float)4.0f, (float)1.5f));
        PartDefinition backR = body2.m_171599_("back_right_leg", legCubeList, PartPose.m_171419_((float)-1.0f, (float)4.0f, (float)1.5f));
        PartDefinition tail1 = body2.m_171599_("tail1", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)2.5f, (float)1.1780972f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail1.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(16, 24).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)1.5f, (float)0.0f, (float)-0.3926991f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.m_171599_("tail3", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition tail4 = tail3.m_171599_("tail4", CubeListBuilder.m_171558_().m_171514_(8, 18).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)3.5f, (float)0.0f, (float)0.3926991f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    @Nonnull
    protected Iterable<ModelPart> m_5607_() {
        return ImmutableSet.of();
    }

    @Nonnull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableSet.of((Object)this.body1);
    }

    private float getBobble(float deg, float ageInTicks) {
        return (float)Math.sin((double)(ageInTicks * 0.03125f) * (Math.PI * 2) + Math.toRadians(deg));
    }

    public void setupAnim(@Nonnull SilverFoxEntity silverFox, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float sin = (float)Math.sin((double)(ageInTicks * 0.125f) * (Math.PI * 2));
        float cos = (float)Math.cos((double)(ageInTicks * 0.0625f) * (Math.PI * 2));
        if (!silverFox.m_21825_()) {
            this.earL.f_104205_ = 0.5235988f + this.getBobble(60.0f, ageInTicks) * 0.09817477f;
            this.earR.f_104205_ = -0.5235988f - this.getBobble(130.0f, ageInTicks) * 0.09817477f;
            this.backL.f_104203_ = limbSwingAmount * sin;
            this.frontR.f_104203_ = limbSwingAmount * sin;
            this.backR.f_104203_ = -limbSwingAmount * sin;
            this.frontL.f_104203_ = -limbSwingAmount * sin;
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.tail1.f_104203_ = 1.1780972f + limbSwingAmount;
            this.tail1.f_104205_ = limbSwingAmount * 0.375f * cos + 0.08726646f * this.getBobble(45.0f, ageInTicks);
            this.tail2.f_104205_ = limbSwingAmount * 0.375f * cos + 0.08726646f * this.getBobble(90.0f, ageInTicks);
            this.tail3.f_104205_ = limbSwingAmount * 0.375f * cos + 0.08726646f * this.getBobble(135.0f, ageInTicks);
            this.tail4.f_104205_ = limbSwingAmount * 0.375f * cos + 0.08726646f * this.getBobble(180.0f, ageInTicks);
            this.setRotateAngle(this.body1, 0.0f, 0.0f, 0.0f);
            this.setRotateAngle(this.body2, 0.0f, 0.0f, 0.0f);
        } else {
            this.setRotateAngle(this.backL, -0.8196066f, -0.31869712f, 0.0f);
            this.setRotateAngle(this.backR, -0.8196066f, 0.3642502f, 0.0f);
            this.setRotateAngle(this.body1, -0.68294734f, 0.0f, 0.0f);
            this.setRotateAngle(this.body2, -0.045553092f, 0.0f, 0.0f);
            this.setRotateAngle(this.earL, 0.0f, -0.2617994f, 0.6085963f);
            this.setRotateAngle(this.earR, 0.0f, 0.2617994f, -0.5988225f);
            this.setRotateAngle(this.frontL, 0.31869712f, 0.0f, 0.0f);
            this.setRotateAngle(this.frontR, 0.31869712f, 0.0f, 0.0f);
            this.setRotateAngle(this.neck, 0.3642502f, 0.0f, 0.0f);
            this.setRotateAngle(this.snout, 0.17453292f, 0.0f, 0.0f);
            this.setRotateAngle(this.tail1, 2.5497515f, 0.0f, 0.061784655f);
            this.setRotateAngle(this.tail2, -0.3926991f, 0.0f, 0.08726646f);
            this.setRotateAngle(this.tail3, 0.0f, 0.0f, 0.061784655f);
            this.setRotateAngle(this.tail4, 0.3926991f, 0.0f, 0.0f);
        }
    }

    public void prepareMobModel(@Nonnull SilverFoxEntity silverFox, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.backL.m_104227_(1.0f, 4.0f, 1.5f);
        this.backR.m_104227_(-1.0f, 4.0f, 1.5f);
        this.body1.m_104227_(0.0f, 15.5f, -2.0f);
        this.body2.m_104227_(0.0f, 0.0f, 5.0f);
        this.earL.m_104227_(1.5f, -1.0f, -1.0f);
        this.earR.m_104227_(-1.5f, -1.0f, -1.0f);
        this.frontL.m_104227_(1.0f, 4.0f, 1.0f);
        this.frontR.m_104227_(-1.0f, 4.0f, 1.0f);
        this.head.m_104227_(0.0f, 0.0f, -4.0f);
        this.neck.m_104227_(0.0f, 1.5f, 2.0f);
        this.snout.m_104227_(0.0f, 0.0f, -3.0f);
        this.tail1.m_104227_(0.0f, 1.0f, 2.5f);
        this.tail2.m_104227_(0.0f, 1.5f, 0.0f);
        this.tail3.m_104227_(0.0f, 3.0f, 0.0f);
        this.tail4.m_104227_(0.0f, 3.5f, 0.0f);
        super.m_6839_((Entity)silverFox, limbSwing, limbSwingAmount, partialTickTime);
    }

    private void setRotateAngle(@Nonnull ModelPart ModelRenderer, float x, float y, float z) {
        ModelRenderer.f_104203_ = x;
        ModelRenderer.f_104204_ = y;
        ModelRenderer.f_104205_ = z;
    }
}

