/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import mysticmods.mysticalworld.entity.SilkwormEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class SilkwormModel
extends EntityModel<SilkwormEntity> {
    private static final int[][] BODY_SIZES = new int[][]{{4, 3, 2}, {6, 4, 5}, {3, 3, 1}, {1, 2, 1}};
    private static final int[][] BODY_TEXS = new int[][]{{0, 0}, {0, 5}, {0, 14}, {0, 18}};
    private static final int BODY_COUNT = BODY_SIZES.length;
    private final ModelPart[] bodyParts = new ModelPart[BODY_COUNT];

    public SilkwormModel(ModelPart pRoot) {
        Arrays.setAll(this.bodyParts, index -> pRoot.m_171324_(SilkwormModel.getSegmentName(index)));
    }

    private static String getSegmentName(int pIndex) {
        return "segment" + pIndex;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        float[] afloat = new float[BODY_COUNT];
        float f = -3.5f;
        for (int i = 0; i < BODY_COUNT; ++i) {
            partdefinition.m_171599_(SilkwormModel.getSegmentName(i), CubeListBuilder.m_171558_().m_171514_(BODY_TEXS[i][0], BODY_TEXS[i][1]).m_171481_((float)BODY_SIZES[i][0] * -0.5f, 0.0f, (float)BODY_SIZES[i][2] * -0.5f, (float)BODY_SIZES[i][0], (float)BODY_SIZES[i][1], (float)BODY_SIZES[i][2]), PartPose.m_171419_((float)0.0f, (float)(24 - BODY_SIZES[i][1]), (float)f));
            afloat[i] = f;
            if (i >= BODY_COUNT - 1) continue;
            f += (float)(BODY_SIZES[i][2] + BODY_SIZES[i + 1][2]) * 0.5f;
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(SilkwormEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        for (int i = 0; i < this.bodyParts.length; ++i) {
            this.bodyParts[i].f_104204_ = Mth.m_14089_((float)(ageInTicks * 0.25f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.01f * (float)(1 + Math.abs(i - 2));
            this.bodyParts[i].f_104200_ = Mth.m_14031_((float)(ageInTicks * 0.25f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.1f * (float)Math.abs(i - 2);
        }
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        for (ModelPart p_228227_8_ : this.bodyParts) {
            p_228227_8_.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }
}

