/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import mysticmods.mysticalworld.client.model.ModelState;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;

public abstract class ShoulderRidingModel<T extends Entity>
extends AgeableListModel<T> {
    public ShoulderRidingModel(boolean scaleHead, float yHeadOffset, float zHeadOfset) {
        super(scaleHead, yHeadOffset, zHeadOfset);
    }

    public ShoulderRidingModel(boolean scaleHead, float yHeadOffset, float zHeadOffset, float babyHeadScale, float babyBodyScale, float bodyYOffset) {
        super(scaleHead, yHeadOffset, zHeadOffset, babyHeadScale, babyBodyScale, bodyYOffset);
    }

    public ShoulderRidingModel(Function<ResourceLocation, RenderType> renderType, boolean scaleHead, float yHeadOffset, float zHeadOffset, float babyHeadScale, float babyBodyScale, float bodyYOffset) {
        super(renderType, scaleHead, yHeadOffset, zHeadOffset, babyHeadScale, babyBodyScale, bodyYOffset);
    }

    public ShoulderRidingModel() {
    }

    public void m_6973_(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.setupAnim(this.getStateFor(pEntity), ((Entity)pEntity).f_19797_, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
    }

    public void m_6839_(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        this.prepare(this.getStateFor(pEntity));
    }

    public void renderOnShoulder(PoseStack pMatrixStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pLimbSwing, float pLimbSwingAmount, float pNetHeadYaw, float pHeadPitch, int ticks) {
        this.prepare(ModelState.SHOULDER);
        this.setupAnim(ModelState.SHOULDER, ticks, pLimbSwing, pLimbSwingAmount, 0.0f, pNetHeadYaw, pHeadPitch);
        if (this.f_102610_) {
            pMatrixStack.m_85836_();
            if (this.f_102007_) {
                float f = 1.5f / this.f_102010_;
                pMatrixStack.m_85841_(f, f, f);
            }
            this.m_5607_().forEach(part -> part.m_104301_(pMatrixStack, pBuffer, pPackedLight, pPackedOverlay));
            pMatrixStack.m_85849_();
            pMatrixStack.m_85836_();
            float f1 = 1.0f / this.f_102011_;
            pMatrixStack.m_85841_(f1, f1, f1);
            pMatrixStack.m_85837_(0.0, (double)(this.f_102012_ / 16.0f), 0.0);
            this.m_5608_().forEach(part -> part.m_104301_(pMatrixStack, pBuffer, pPackedLight, pPackedOverlay));
            pMatrixStack.m_85849_();
        } else {
            this.m_5607_().forEach(part -> part.m_104301_(pMatrixStack, pBuffer, pPackedLight, pPackedOverlay));
            this.m_5608_().forEach(part -> part.m_104301_(pMatrixStack, pBuffer, pPackedLight, pPackedOverlay));
        }
    }

    protected ModelState getStateFor(T entity) {
        if (entity instanceof TamableAnimal) {
            TamableAnimal tameable = (TamableAnimal)entity;
            if (tameable.m_21825_()) {
                return ModelState.SITTING;
            }
            return ModelState.NORMAL;
        }
        return ModelState.NORMAL;
    }

    protected abstract void setupAnim(ModelState var1, int var2, float var3, float var4, float var5, float var6, float var7);

    protected abstract void prepare(ModelState var1);

    public abstract ResourceLocation getTexture(ModelState var1);
}

