/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.client.model;

import com.google.common.collect.ImmutableSet;
import javax.annotation.Nonnull;
import mysticmods.mysticalworld.entity.OwlEntity;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OwlModel
extends AgeableListModel<OwlEntity> {
    private final ModelPart body;
    private final ModelPart footR;
    private final ModelPart footL;
    private final ModelPart wingR1;
    private final ModelPart wingR2;
    private final ModelPart wingL1;
    private final ModelPart wingL2;
    private final ModelPart tail;
    private final ModelPart head;
    private final ModelPart tuftR;
    private final ModelPart tuftL;
    private State state = State.STANDING;

    public OwlModel(ModelPart pRoot) {
        super(true, 5.0f, 2.0f);
        this.body = pRoot.m_171324_("body");
        this.footR = this.body.m_171324_("foot_right");
        this.footL = this.body.m_171324_("foot_left");
        this.wingR1 = this.body.m_171324_("wing_right1");
        this.wingR2 = this.wingR1.m_171324_("wing_right2");
        this.wingL1 = this.body.m_171324_("wing_left1");
        this.wingL2 = this.wingL1.m_171324_("wing_left2");
        this.tail = this.body.m_171324_("tail");
        this.head = this.body.m_171324_("head");
        this.tuftR = this.head.m_171324_("tuft_right");
        this.tuftL = this.head.m_171324_("tuft_left");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -13.0f, -4.0f, 8.0f, 9.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition footR = body.m_171599_("foot_right", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 2.0f, 3.0f).m_171514_(26, 48).m_171481_(-1.0f, 2.0f, 0.5f, 2.0f, 2.0f, 0.0f).m_171514_(0, 48).m_171481_(-1.0f, 4.0f, -1.5f, 2.0f, 0.0f, 2.0f), PartPose.m_171419_((float)-1.5f, (float)-4.0f, (float)-0.5f));
        PartDefinition footL = body.m_171599_("foot_left", CubeListBuilder.m_171558_().m_171514_(12, 43).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 2.0f, 3.0f).m_171514_(22, 48).m_171481_(-1.0f, 2.0f, 0.5f, 2.0f, 2.0f, 0.0f).m_171514_(8, 48).m_171481_(-1.0f, 4.0f, -1.5f, 2.0f, 0.0f, 2.0f), PartPose.m_171419_((float)1.5f, (float)-4.0f, (float)-0.5f));
        PartDefinition wingR1 = body.m_171599_("wing_right1", CubeListBuilder.m_171558_().m_171514_(16, 17).m_171481_(-1.0f, 0.0f, -2.0f, 1.0f, 7.0f, 7.0f), PartPose.m_171419_((float)-4.0f, (float)-13.0f, (float)-1.0f));
        PartDefinition wingR2 = wingR1.m_171599_("wing_right2", CubeListBuilder.m_171558_().m_171514_(14, 31).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 6.0f, 6.0f), PartPose.m_171423_((float)-1.0f, (float)7.0f, (float)-2.0f, (float)0.1745f, (float)0.0349f, (float)-0.1745f));
        PartDefinition wingL1 = body.m_171599_("wing_left1", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171481_(0.0f, 0.0f, -2.0f, 1.0f, 7.0f, 7.0f), PartPose.m_171419_((float)4.0f, (float)-13.0f, (float)-1.0f));
        PartDefinition wingL2 = wingL1.m_171599_("wing_left2", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171481_(-1.0f, 0.0f, 0.0f, 1.0f, 6.0f, 6.0f), PartPose.m_171423_((float)1.0f, (float)7.0f, (float)-2.0f, (float)0.1745f, (float)-0.0349f, (float)0.1745f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(28, 31).m_171481_(-3.0f, 0.0f, -2.0f, 6.0f, 4.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)4.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-3.5f, -6.0f, -3.5f, 7.0f, 6.0f, 7.0f).m_171514_(16, 48).m_171481_(-1.0f, -3.0f, -4.5f, 2.0f, 2.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)0.0f));
        PartDefinition tuftR = head.m_171599_("tuft_right", CubeListBuilder.m_171558_().m_171514_(24, 43).m_171481_(-2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 4.0f), PartPose.m_171423_((float)-2.0f, (float)-6.0f, (float)-3.0f, (float)0.4363f, (float)-0.3491f, (float)0.0f));
        PartDefinition tuftL = head.m_171599_("tuft_left", CubeListBuilder.m_171558_().m_171514_(36, 43).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 4.0f), PartPose.m_171423_((float)2.0f, (float)-6.0f, (float)-3.0f, (float)0.4363f, (float)0.3491f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Nonnull
    protected Iterable<ModelPart> m_5607_() {
        return ImmutableSet.of();
    }

    @Nonnull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableSet.of((Object)this.body);
    }

    public void setupAnim(OwlEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean hootfire;
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104205_ = 0.0f;
        boolean bl = hootfire = entityIn.m_8077_() && entityIn.m_7770_() != null && entityIn.m_7770_().getString().equals("Hootfire");
        if (this.state == State.FLYING && !hootfire) {
            this.setRotationAngle(this.body, 0.45f, 0.0f, 0.0f);
            this.setRotationAngle(this.footR, 0.25f, 0.0f, 0.0f);
            this.setRotationAngle(this.footL, 0.25f, 0.0f, 0.0f);
            this.setRotationAngle(this.tail, 0.15f, 0.0f, 0.0f);
            this.setRotationAngle(this.head, -0.3f, 0.0f, 0.0f);
            float wingR_rotation = -(0.65f * (float)Math.sin(ageInTicks) - 1.625f);
            float wingL_rotation = 0.65f * (float)Math.sin(ageInTicks) - 1.625f;
            this.setRotationAngle(this.wingR1, 0.45f, 0.0f, wingR_rotation);
            this.setRotationAngle(this.wingL1, 0.45f, 0.0f, wingL_rotation);
            this.setRotationAngle(this.wingR2, 0.45f, 0.0f, 0.05f * wingR_rotation);
            this.setRotationAngle(this.wingL2, 0.45f, 0.0f, 0.05f * wingL_rotation);
        } else {
            this.setRotationAngle(this.body, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.footR, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.footL, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.tail, 0.5236f, 0.0f, 0.0f);
            this.setRotationAngle(this.head, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.wingR1, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.wingR2, 0.1745f, 0.0349f, -0.1745f);
            this.setRotationAngle(this.wingL1, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.wingL2, 0.1745f, -0.0349f, 0.1745f);
        }
    }

    public void prepareMobModel(OwlEntity owl, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.state = owl.m_142592_() ? State.FLYING : State.STANDING;
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum State {
        FLYING,
        STANDING,
        SITTING;

    }
}

