/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.client.model;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import mysticmods.mysticalworld.entity.LavaCatEntity;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class LavaCatModel<T extends LavaCatEntity>
extends AgeableListModel<T> {
    protected final ModelPart leftHindLeg;
    protected final ModelPart rightHindLeg;
    protected final ModelPart leftFrontLeg;
    protected final ModelPart rightFrontLeg;
    protected final ModelPart tail1;
    protected final ModelPart tail2;
    protected final ModelPart head;
    protected final ModelPart body;
    private int state = 1;

    public LavaCatModel(ModelPart pRoot) {
        super(true, 5.0f, 2.0f);
        this.head = pRoot.m_171324_("head");
        this.body = pRoot.m_171324_("body");
        this.tail1 = pRoot.m_171324_("tail1");
        this.tail2 = pRoot.m_171324_("tail2");
        this.leftHindLeg = pRoot.m_171324_("left_hind_leg");
        this.rightHindLeg = pRoot.m_171324_("right_hind_leg");
        this.leftFrontLeg = pRoot.m_171324_("left_front_leg");
        this.rightFrontLeg = pRoot.m_171324_("right_front_leg");
    }

    public static MeshDefinition createBodyMesh(CubeDeformation pCubeDeformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171525_("main", -2.5f, -2.0f, -3.0f, 5.0f, 4.0f, 5.0f, pCubeDeformation).m_171544_("nose", -1.5f, 0.0f, -4.0f, 3, 2, 2, pCubeDeformation, 0, 24).m_171544_("ear1", -2.0f, -3.0f, 0.0f, 1, 1, 2, pCubeDeformation, 0, 10).m_171544_("ear2", 1.0f, -3.0f, 0.0f, 1, 1, 2, pCubeDeformation, 6, 10), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-9.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171488_(-2.0f, 3.0f, -8.0f, 4.0f, 16.0f, 6.0f, pCubeDeformation), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)-10.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("tail1", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f, pCubeDeformation), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)8.0f, (float)0.9f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(4, 15).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f, pCubeDeformation), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)14.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.m_171558_().m_171514_(8, 13).m_171488_(-1.0f, 0.0f, 1.0f, 2.0f, 6.0f, 2.0f, pCubeDeformation);
        partdefinition.m_171599_("left_hind_leg", cubelistbuilder, PartPose.m_171419_((float)1.1f, (float)18.0f, (float)5.0f));
        partdefinition.m_171599_("right_hind_leg", cubelistbuilder, PartPose.m_171419_((float)-1.1f, (float)18.0f, (float)5.0f));
        CubeListBuilder cubelistbuilder1 = CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 2.0f, pCubeDeformation);
        partdefinition.m_171599_("left_front_leg", cubelistbuilder1, PartPose.m_171419_((float)1.2f, (float)14.1f, (float)-5.0f));
        partdefinition.m_171599_("right_front_leg", cubelistbuilder1, PartPose.m_171419_((float)-1.2f, (float)14.1f, (float)-5.0f));
        return meshdefinition;
    }

    public static LayerDefinition createBodyLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)LavaCatModel.createBodyMesh(CubeDeformation.f_171458_), (int)64, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.leftHindLeg, (Object)this.rightHindLeg, (Object)this.leftFrontLeg, (Object)this.rightFrontLeg, (Object)this.tail1, (Object)this.tail2, (Object)this.head);
    }

    public void setupAnim(@Nonnull T entityIn, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        if (this.state != 3) {
            this.body.f_104203_ = 1.5707964f;
            if (this.state == 2) {
                this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f)) * pLimbSwingAmount;
                this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f + 0.3f)) * pLimbSwingAmount;
                this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f + (float)Math.PI + 0.3f)) * pLimbSwingAmount;
                this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * pLimbSwingAmount;
                this.tail2.f_104203_ = 1.7278761f + 0.31415927f * Mth.m_14089_((float)pLimbSwing) * pLimbSwingAmount;
            } else {
                this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f)) * pLimbSwingAmount;
                this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * pLimbSwingAmount;
                this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * pLimbSwingAmount;
                this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f)) * pLimbSwingAmount;
                this.tail2.f_104203_ = this.state == 1 ? 1.7278761f + 0.7853982f * Mth.m_14089_((float)pLimbSwing) * pLimbSwingAmount : 1.7278761f + 0.47123894f * Mth.m_14089_((float)pLimbSwing) * pLimbSwingAmount;
            }
        }
    }

    public void prepareMobModel(T entityocelot, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.body.f_104201_ = 12.0f;
        this.body.f_104202_ = -10.0f;
        this.head.f_104201_ = 15.0f;
        this.head.f_104202_ = -9.0f;
        this.tail1.f_104201_ = 15.0f;
        this.tail1.f_104202_ = 8.0f;
        this.tail2.f_104201_ = 20.0f;
        this.tail2.f_104202_ = 14.0f;
        this.leftFrontLeg.f_104201_ = 14.1f;
        this.leftFrontLeg.f_104202_ = -5.0f;
        this.rightFrontLeg.f_104201_ = 14.1f;
        this.rightFrontLeg.f_104202_ = -5.0f;
        this.leftHindLeg.f_104201_ = 18.0f;
        this.leftHindLeg.f_104202_ = 5.0f;
        this.rightHindLeg.f_104201_ = 18.0f;
        this.rightHindLeg.f_104202_ = 5.0f;
        this.tail1.f_104203_ = 0.9f;
        this.body.f_104203_ = 0.0f;
        this.tail2.f_104203_ = 0.0f;
        this.leftFrontLeg.f_104203_ = 0.0f;
        this.rightFrontLeg.f_104203_ = 0.0f;
        this.leftHindLeg.f_104203_ = 0.0f;
        this.rightHindLeg.f_104203_ = 0.0f;
        if (entityocelot.m_21825_()) {
            this.body.f_104203_ = 0.7853982f;
            this.body.f_104201_ += -4.0f;
            this.body.f_104202_ += 5.0f;
            this.head.f_104201_ += -3.3f;
            this.head.f_104202_ += 1.0f;
            this.tail1.f_104201_ += 8.0f;
            this.tail1.f_104202_ += -2.0f;
            this.tail2.f_104201_ += 2.0f;
            this.tail2.f_104202_ += -0.8f;
            this.tail1.f_104203_ = 1.7278761f;
            this.tail2.f_104203_ = 2.670354f;
            this.leftFrontLeg.f_104203_ = -0.15707964f;
            this.leftFrontLeg.f_104201_ = 15.8f;
            this.leftFrontLeg.f_104202_ = -7.0f;
            this.rightFrontLeg.f_104203_ = -0.15707964f;
            this.rightFrontLeg.f_104201_ = 15.8f;
            this.rightFrontLeg.f_104202_ = -7.0f;
            this.leftHindLeg.f_104203_ = -1.5707964f;
            this.leftHindLeg.f_104201_ = 21.0f;
            this.leftHindLeg.f_104202_ = 1.0f;
            this.rightHindLeg.f_104203_ = -1.5707964f;
            this.rightHindLeg.f_104201_ = 21.0f;
            this.rightHindLeg.f_104202_ = 1.0f;
            this.state = 3;
        } else {
            this.state = 1;
        }
    }
}

