/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.client.model;

import com.google.common.collect.ImmutableSet;
import javax.annotation.Nonnull;
import mysticmods.mysticalworld.entity.FrogEntity;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class FrogModel
extends AgeableListModel<FrogEntity> {
    private final ModelPart body;
    private final ModelPart backR;
    private final ModelPart backL;
    private final ModelPart frontR;
    private final ModelPart frontL;
    private final ModelPart head;

    public FrogModel(ModelPart pRoot) {
        super(true, 5.0f, 2.0f);
        this.body = pRoot.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.backL = this.body.m_171324_("back_left_leg");
        this.backR = this.body.m_171324_("back_right_leg");
        this.frontL = this.body.m_171324_("front_left_leg");
        this.frontR = this.body.m_171324_("front_right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(-1.5f, -1.0f, -3.0f, 3.0f, 2.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)22.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(4, 3).m_171481_(-1.5f, -1.0f, -3.0f, 3.0f, 2.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-3.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition backL = body.m_171599_("back_left_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, 0.0f, -0.5f, 2.0f, 4.0f, 1.0f), PartPose.m_171423_((float)1.0f, (float)0.5f, (float)1.5f, (float)-0.6981f, (float)-0.5236f, (float)-0.5236f));
        PartDefinition backR = body.m_171599_("back_right_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171481_(-1.0f, 0.0f, -0.5f, 2.0f, 4.0f, 1.0f).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)0.5f, (float)1.5f, (float)-0.6981f, (float)0.5236f, (float)0.5236f));
        PartDefinition frontL = body.m_171599_("front_left_leg", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171480_().m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)-0.25f, (float)-2.5f, (float)0.2618f, (float)0.0f, (float)-0.2618f));
        PartDefinition frontR = body.m_171599_("front_right_leg", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171480_().m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)-0.25f, (float)-2.5f, (float)0.2618f, (float)0.0f, (float)0.2618f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    @Nonnull
    protected Iterable<ModelPart> m_5607_() {
        return ImmutableSet.of();
    }

    @Nonnull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableSet.of((Object)this.body);
    }

    public void setupAnim(@Nonnull FrogEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.backL.f_104203_ = -0.6981317f + 1.5f * entity.getOffGround(ageInTicks - (float)((int)ageInTicks));
        this.backR.f_104203_ = -0.6981317f + 1.5f * entity.getOffGround(ageInTicks - (float)((int)ageInTicks));
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
    }
}

