/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.client.model;

import com.google.common.collect.ImmutableSet;
import javax.annotation.Nonnull;
import mysticmods.mysticalworld.client.model.ModelState;
import mysticmods.mysticalworld.client.model.ShoulderRidingModel;
import mysticmods.mysticalworld.entity.BeetleEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class BeetleModel
extends ShoulderRidingModel<BeetleEntity> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart antennaR1;
    private final ModelPart antennaL1;
    private final ModelPart antennaR2;
    private final ModelPart antennaL2;
    private final ModelPart wingL;
    private final ModelPart wingR;
    private final ModelPart legL1;
    private final ModelPart legL2;
    private final ModelPart legL3;
    private final ModelPart legR1;
    private final ModelPart legR2;
    private final ModelPart legR3;

    public BeetleModel(ModelPart pRoot) {
        super(true, 5.0f, 2.0f);
        this.body = pRoot.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.antennaL1 = this.head.m_171324_("antenna_left");
        this.antennaL2 = this.antennaL1.m_171324_("antenna_left2");
        this.antennaR1 = this.head.m_171324_("antenna_right");
        this.antennaR2 = this.antennaR1.m_171324_("antenna_right2");
        this.legL1 = this.body.m_171324_("leg_left1");
        this.legL2 = this.body.m_171324_("leg_left2");
        this.legL3 = this.body.m_171324_("leg_left3");
        this.legR1 = this.body.m_171324_("leg_right1");
        this.legR2 = this.body.m_171324_("leg_right2");
        this.legR3 = this.body.m_171324_("leg_right3");
        this.wingL = this.body.m_171324_("wing_left");
        this.wingR = this.body.m_171324_("wing_right");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171481_(-2.5f, -2.0f, 0.0f, 5.0f, 4.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)-4.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(-2.0f, -1.25f, -3.0f, 4.0f, 3.0f, 3.0f), PartPose.m_171430_((float)0.17453292f, (float)0.0f, (float)0.0f));
        CubeListBuilder antennaCubeList = CubeListBuilder.m_171558_().m_171514_(24, 6).m_171481_(-0.5f, -5.0f, -0.5f, 1.0f, 5.0f, 1.0f);
        PartDefinition antennaL1 = head.m_171599_("antenna_left", antennaCubeList, PartPose.m_171423_((float)1.0f, (float)0.0f, (float)-0.5f, (float)0.1308997f, (float)0.0f, (float)0.2617994f));
        PartDefinition antennaL2 = antennaL1.m_171599_("antenna_left2", antennaCubeList, PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.3926991f, (float)0.0f, (float)0.0f));
        PartDefinition antennaR1 = head.m_171599_("antenna_right", antennaCubeList, PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)-0.5f, (float)0.1308997f, (float)0.0f, (float)-0.2617994f));
        PartDefinition antennaR2 = antennaR1.m_171599_("antenna_right2", antennaCubeList, PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.3926991f, (float)0.0f, (float)0.0f));
        CubeListBuilder legCubeList = CubeListBuilder.m_171558_().m_171514_(18, 6).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 7.0f, 1.0f);
        PartDefinition legL1 = body.m_171599_("leg_left1", legCubeList, PartPose.m_171423_((float)1.5f, (float)1.0f, (float)1.0f, (float)-0.2617994f, (float)0.0f, (float)-0.2617994f));
        PartDefinition legR1 = body.m_171599_("leg_right1", legCubeList, PartPose.m_171423_((float)-1.5f, (float)1.0f, (float)1.0f, (float)-0.2617994f, (float)0.0f, (float)0.2617994f));
        PartDefinition legL2 = body.m_171599_("leg_left2", legCubeList, PartPose.m_171423_((float)2.0f, (float)1.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)-0.2617994f));
        PartDefinition legR2 = body.m_171599_("leg_right2", legCubeList, PartPose.m_171423_((float)-2.0f, (float)1.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.2617994f));
        PartDefinition legL3 = body.m_171599_("leg_left3", legCubeList, PartPose.m_171423_((float)1.5f, (float)1.0f, (float)6.0f, (float)0.2617994f, (float)0.0f, (float)-0.2617994f));
        PartDefinition legR3 = body.m_171599_("leg_right3", legCubeList, PartPose.m_171423_((float)-1.5f, (float)1.0f, (float)6.0f, (float)0.2617994f, (float)0.0f, (float)0.2617994f));
        CubeListBuilder wingCubeList = CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.5f, 0.0f, -1.0f, 5.0f, 8.0f, 3.0f);
        PartDefinition wingL = body.m_171599_("wing_left", wingCubeList, PartPose.m_171423_((float)1.5f, (float)-0.5f, (float)1.0f, (float)1.7453293f, (float)0.17453292f, (float)0.2617994f));
        PartDefinition wingR = body.m_171599_("wing_right", wingCubeList.m_171480_(), PartPose.m_171423_((float)-1.5f, (float)-0.5f, (float)1.0f, (float)1.7453293f, (float)-0.17453292f, (float)-0.2617994f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    @Nonnull
    protected Iterable<ModelPart> m_5607_() {
        return ImmutableSet.of();
    }

    @Nonnull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableSet.of((Object)this.body);
    }

    private float getSwing(float deg, float ageInTicks) {
        return (float)Math.sin((double)(ageInTicks * 0.125f) * (Math.PI * 2) + Math.toRadians(deg));
    }

    private float getBobble(float deg, float ageInTicks) {
        return (float)Math.sin((double)(ageInTicks * 0.03125f) * (Math.PI * 2) + Math.toRadians(deg));
    }

    @Override
    protected void setupAnim(ModelState state, int ticks, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.antennaR1.f_104203_ = 0.1308997f + this.getBobble(30.0f, ageInTicks) * 0.2617994f;
        this.antennaL1.f_104203_ = 0.1308997f + this.getBobble(100.0f, ageInTicks) * 0.2617994f;
        this.wingL.f_104204_ = 0.17453292f + 0.08726646f * this.getBobble(45.0f, ageInTicks);
        this.wingR.f_104204_ = -0.17453292f - 0.08726646f * this.getBobble(160.0f, ageInTicks);
        if (state == ModelState.NORMAL) {
            this.legL1.f_104205_ = limbSwingAmount * this.getSwing(0.0f, ageInTicks) - 0.2617994f;
            this.legL2.f_104205_ = limbSwingAmount * this.getSwing(120.0f, ageInTicks) - 0.2617994f;
            this.legL3.f_104205_ = limbSwingAmount * this.getSwing(240.0f, ageInTicks) - 0.2617994f;
            this.legR1.f_104205_ = limbSwingAmount * this.getSwing(180.0f, ageInTicks) + 0.2617994f;
            this.legR2.f_104205_ = limbSwingAmount * this.getSwing(300.0f, ageInTicks) + 0.2617994f;
            this.legR3.f_104205_ = limbSwingAmount * this.getSwing(60.0f, ageInTicks) + 0.2617994f;
        }
    }

    @Override
    protected void prepare(ModelState state) {
        if (state == ModelState.SITTING) {
            this.body.m_104227_(0.0f, 20.0f, -4.0f);
            this.setRotateAngle(this.legR1, -0.4619009f, -0.12228425f, 1.2226124f);
            this.setRotateAngle(this.legR2, 0.0f, 0.0f, 1.1609088f);
            this.setRotateAngle(this.legR3, 0.2617994f, 0.0f, 1.1727415f);
            this.setRotateAngle(this.legL1, -0.5508349f, 0.12228425f, -1.2137976f);
            this.setRotateAngle(this.legL2, 0.0f, 0.0f, -1.1873531f);
            this.setRotateAngle(this.legL3, 0.2617994f, 0.0f, -1.2314272f);
        } else {
            this.body.m_104227_(0.0f, 16.0f, -4.0f);
            this.setRotateAngle(this.legR1, -0.2617994f, 0.0f, 0.2617994f);
            this.setRotateAngle(this.legR2, 0.0f, 0.0f, 0.2617994f);
            this.setRotateAngle(this.legR3, 0.2617994f, 0.0f, 0.2617994f);
            this.setRotateAngle(this.legL1, -0.2617994f, 0.0f, -0.2617994f);
            this.setRotateAngle(this.legL2, 0.0f, 0.0f, -0.2617994f);
            this.setRotateAngle(this.legL3, 0.2617994f, 0.0f, -0.2617994f);
        }
    }

    @Override
    public ResourceLocation getTexture(ModelState state) {
        return new ResourceLocation("mysticalworld:textures/entity/beetle_blue.png");
    }

    private void setRotateAngle(@Nonnull ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

