/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.capability;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import mysticmods.mysticalworld.MysticalWorld;
import mysticmods.mysticalworld.api.Capabilities;
import mysticmods.mysticalworld.api.IPlayerShoulderCapability;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerShoulderCapability
implements IPlayerShoulderCapability,
ICapabilitySerializable<CompoundTag>,
ICapabilityProvider {
    public static MethodHandle setRightShoulder = null;
    public static MethodHandle setLeftShoulder = null;
    private CompoundTag animalSerialized = new CompoundTag();
    private boolean shouldered = false;
    private ResourceLocation registryName = null;

    @Override
    public CompoundTag getAnimalSerialized() {
        return this.animalSerialized;
    }

    @Override
    public boolean isShouldered() {
        return this.shouldered;
    }

    @Override
    public ResourceLocation getEntityName() {
        return this.registryName;
    }

    @Override
    @javax.annotation.Nullable
    public EntityType<?> getEntityType(ResourceLocation registryName) {
        return (EntityType)ForgeRegistries.ENTITIES.getValue(registryName);
    }

    @Override
    @javax.annotation.Nullable
    public EntityType<?> getEntityType() {
        return this.getEntityType(this.getEntityName());
    }

    @Override
    public void drop() {
        this.animalSerialized = new CompoundTag();
        this.shouldered = false;
        this.registryName = null;
    }

    @Override
    public void shoulder(Entity entity) {
        this.animalSerialized = new CompoundTag();
        entity.m_20223_(this.animalSerialized);
        this.shouldered = true;
        this.registryName = entity.m_6095_().getRegistryName();
    }

    @Override
    public CompoundTag generateShoulderNBT() {
        CompoundTag result = new CompoundTag();
        result.m_128379_("Silent", true);
        result.m_128359_("id", this.registryName == null ? "minecraft:pig" : this.registryName.toString());
        return result;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return Capabilities.PLAYER_SHOULDER.orEmpty(cap, LazyOptional.of(() -> this));
    }

    public CompoundTag serializeNBT() {
        CompoundTag result = new CompoundTag();
        result.m_128365_("animalSerialized", (Tag)this.animalSerialized);
        result.m_128379_("shouldered", this.shouldered);
        result.m_128359_("registryName", this.registryName == null ? "" : this.registryName.toString());
        return result;
    }

    public void deserializeNBT(CompoundTag incoming) {
        if (incoming.m_128441_("animalSerialized")) {
            this.animalSerialized = incoming.m_128469_("animalSerialized");
        }
        if (incoming.m_128441_("shouldered")) {
            this.shouldered = incoming.m_128471_("shouldered");
        }
        if (incoming.m_128441_("registryName")) {
            this.registryName = incoming.m_128461_("registryName").isEmpty() ? null : new ResourceLocation(incoming.m_128461_("registryName"));
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Method setLeft = ObfuscationReflectionHelper.findMethod(Player.class, (String)"m_36362_", (Class[])new Class[]{CompoundTag.class});
        setLeft.setAccessible(true);
        Method setRight = ObfuscationReflectionHelper.findMethod(Player.class, (String)"m_36364_", (Class[])new Class[]{CompoundTag.class});
        try {
            setLeftShoulder = lookup.unreflect(setLeft);
            setRightShoulder = lookup.unreflect(setRight);
        }
        catch (IllegalAccessException e) {
            MysticalWorld.LOG.error("Unable to unprotect setRightShoulder", (Throwable)e);
        }
    }
}

