/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.capability;

import mysticmods.mysticalworld.api.Capabilities;
import mysticmods.mysticalworld.api.IAnimalCooldownCapability;
import net.minecraft.core.Direction;
import net.minecraft.nbt.LongTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimalCooldownCapability
implements IAnimalCooldownCapability,
ICapabilitySerializable<LongTag>,
ICapabilityProvider {
    private long expiry = -1L;

    @Override
    public long getExpiry() {
        return this.expiry;
    }

    @Override
    public void setExpiry(long value) {
        this.expiry = value;
    }

    @Override
    public void setCooldown(int value) {
        this.expiry = this.getGameTime() + (long)value;
    }

    private long getGameTime() {
        ServerLevel overworld = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
        if (overworld != null) {
            return overworld.m_46467_();
        }
        return 0L;
    }

    @Override
    public boolean hasExpired() {
        return this.getGameTime() >= this.expiry;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return Capabilities.ANIMAL_COOLDOWN.orEmpty(cap, LazyOptional.of(() -> this));
    }

    public LongTag serializeNBT() {
        return LongTag.m_128882_((long)this.expiry);
    }

    public void deserializeNBT(LongTag nbt) {
        this.expiry = nbt.m_7046_();
    }
}

