/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.repack.noobutil.block.BaseBlocks;
import mysticmods.mysticalworld.repack.noobutil.util.VoxelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class OakAppleBlock
extends BaseBlocks.CropsBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape[] south_shapes = new VoxelShape[]{Block.m_49796_((double)7.0, (double)7.0, (double)15.0, (double)9.0, (double)9.0, (double)16.0), Block.m_49796_((double)7.0, (double)7.0, (double)14.0, (double)9.0, (double)9.0, (double)16.0), Block.m_49796_((double)6.5, (double)6.5, (double)14.0, (double)9.5, (double)9.5, (double)16.0), Block.m_49796_((double)6.5, (double)6.5, (double)13.0, (double)9.5, (double)9.5, (double)16.0)};
    private static final VoxelShape[] north_shapes = new VoxelShape[]{VoxelUtil.rotateHorizontal(south_shapes[0], Direction.SOUTH), VoxelUtil.rotateHorizontal(south_shapes[1], Direction.SOUTH), VoxelUtil.rotateHorizontal(south_shapes[2], Direction.SOUTH), VoxelUtil.rotateHorizontal(south_shapes[3], Direction.SOUTH)};
    private static final VoxelShape[] west_shapes = new VoxelShape[]{VoxelUtil.rotateHorizontal(south_shapes[0], Direction.EAST), VoxelUtil.rotateHorizontal(south_shapes[1], Direction.EAST), VoxelUtil.rotateHorizontal(south_shapes[2], Direction.EAST), VoxelUtil.rotateHorizontal(south_shapes[3], Direction.EAST)};
    private static final VoxelShape[] east_shapes = new VoxelShape[]{VoxelUtil.rotateHorizontal(south_shapes[0], Direction.WEST), VoxelUtil.rotateHorizontal(south_shapes[1], Direction.WEST), VoxelUtil.rotateHorizontal(south_shapes[2], Direction.WEST), VoxelUtil.rotateHorizontal(south_shapes[3], Direction.WEST)};

    public OakAppleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public IntegerProperty m_7959_() {
        return AGE;
    }

    public int m_7419_() {
        return 3;
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if (worldIn.f_46443_) {
            return;
        }
        if (!this.canBlockStay((Level)worldIn, pos, state)) {
            worldIn.m_46961_(pos, true);
        } else {
            int i = (Integer)state.m_61143_((Property)AGE);
            if (i < 3 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(5) == 0 ? 1 : 0) != 0)) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
                ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)worldIn.m_8055_(pos));
            }
        }
    }

    public boolean canBlockStay(Level worldIn, BlockPos pos, BlockState state) {
        BlockState iblockstate = worldIn.m_8055_(pos = pos.m_142300_((Direction)state.m_61143_((Property)FACING)));
        Block block = iblockstate.m_60734_();
        return block == Blocks.f_49999_ || block == Blocks.f_50011_ || block == Blocks.f_50004_ || block == Blocks.f_50043_;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext context) {
        int i = (Integer)state.m_61143_((Property)AGE);
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case SOUTH: {
                return south_shapes[i];
            }
            default: {
                return north_shapes[i];
            }
            case WEST: {
                return west_shapes[i];
            }
            case EAST: 
        }
        return east_shapes[i];
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return this.m_6843_(state, mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected boolean m_6266_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.canBlockStay(worldIn, pos, state) && !worldIn.f_46443_) {
            worldIn.m_46961_(pos, true);
        }
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return false;
    }

    public void m_52263_(Level worldIn, BlockPos pos, BlockState state) {
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)), 3);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, AGE});
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer != null) {
            Direction enumfacing = Direction.m_122364_((double)placer.m_146908_());
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)FACING, (Comparable)enumfacing), 2);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_43719_();
        if (!facing.m_122434_().m_122479_()) {
            facing = Direction.NORTH;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing.m_122424_())).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
    }
}

