/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.blocks;

import javax.annotation.Nullable;
import mysticmods.mysticalworld.repack.noobutil.util.VoxelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BonesBlock
extends HorizontalDirectionalBlock {
    private static final VoxelShape bone_pile_south_shape = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0);
    private static final VoxelShape bone_pile_north_shape = VoxelUtil.rotateHorizontal(bone_pile_south_shape, Direction.SOUTH);
    private static final VoxelShape bone_pile_west_shape = VoxelUtil.rotateHorizontal(bone_pile_south_shape, Direction.EAST);
    private static final VoxelShape bone_pile_east_shape = VoxelUtil.rotateHorizontal(bone_pile_south_shape, Direction.WEST);
    private static final VoxelShape skeleton_south_shape = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)8.0, (double)16.0);
    private static final VoxelShape skeleton_north_shape = VoxelUtil.rotateHorizontal(skeleton_south_shape, Direction.SOUTH);
    private static final VoxelShape skeleton_west_shape = VoxelUtil.rotateHorizontal(skeleton_south_shape, Direction.EAST);
    private static final VoxelShape skeleton_east_shapes = VoxelUtil.rotateHorizontal(skeleton_south_shape, Direction.WEST);
    private final BoneType type;

    public BonesBlock(BlockBehaviour.Properties p_i48377_1_, BoneType type) {
        super(p_i48377_1_);
        this.type = type;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)f_54117_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return this.m_6843_(state, mirrorIn.m_54846_((Direction)state.m_61143_((Property)f_54117_)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_((Property)f_54117_);
        VoxelShape shape = null;
        switch (this.type) {
            case BOTTOM: 
            case TOP: {
                switch (facing) {
                    case EAST: {
                        shape = skeleton_east_shapes;
                        break;
                    }
                    case WEST: {
                        shape = skeleton_west_shape;
                        break;
                    }
                    case SOUTH: {
                        shape = skeleton_south_shape;
                        break;
                    }
                    case NORTH: {
                        shape = skeleton_north_shape;
                    }
                }
                break;
            }
            case PILE: {
                switch (facing) {
                    case EAST: {
                        shape = bone_pile_east_shape;
                        break;
                    }
                    case WEST: {
                        shape = bone_pile_west_shape;
                        break;
                    }
                    case SOUTH: {
                        shape = bone_pile_south_shape;
                        break;
                    }
                    case NORTH: {
                        shape = bone_pile_north_shape;
                    }
                }
                break;
            }
            default: {
                shape = bone_pile_south_shape;
            }
        }
        if (shape == null) {
            return bone_pile_south_shape;
        }
        return shape;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_().m_122424_());
    }

    public static enum BoneType {
        PILE,
        TOP,
        BOTTOM;

    }
}

