/*
 * Decompiled with CFR 0.152.
 */
package commonnetwork.networking;

import commonnetwork.Constants;
import commonnetwork.networking.PacketRegistrationHandler;
import commonnetwork.networking.data.CommonPacketWrapper;
import commonnetwork.networking.data.PacketContainer;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import commonnetwork.networking.exceptions.RegistrationException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.payload.PayloadConnection;
import net.minecraftforge.network.payload.PayloadFlow;

public class ForgeNetworkHandler
extends PacketRegistrationHandler {
    private final Map<Class<?>, Message<?>> CHANNELS = new HashMap();

    public ForgeNetworkHandler(Side side) {
        super(side);
    }

    @Override
    protected <T> void registerPacket(PacketContainer<T> container) {
        if (this.CHANNELS.get(container.classType()) == null) {
            PayloadConnection channelBuilder = ChannelBuilder.named((ResourceLocation)container.type().id()).optional().payloadChannel();
            Channel channel = container.packetType() == PacketContainer.PacketType.PLAY ? ((PayloadFlow)channelBuilder.play().bidirectional()).addMain(container.getType(), container.getCodec(), (msg, ctx) -> this.buildHandler(container.handler()).accept(msg.packet(), (CustomPayloadEvent.Context)ctx)).build() : ((PayloadFlow)channelBuilder.configuration().bidirectional()).addMain(container.getType(), container.getCodec(), (msg, ctx) -> this.buildHandler(container.handler()).accept(msg.packet(), (CustomPayloadEvent.Context)ctx)).build();
            this.CHANNELS.put(container.classType(), new Message<T>((Channel<CustomPacketPayload>)channel, container));
        }
    }

    @Override
    public <T> void sendToServer(T packet, boolean ignoreCheck) {
        Message<?> message = this.CHANNELS.get(packet.getClass());
        if (message != null) {
            Channel<CustomPacketPayload> channel = message.channel();
            Connection connection = Minecraft.getInstance().getConnection().getConnection();
            if (ignoreCheck || channel.isRemotePresent(connection)) {
                channel.send(new CommonPacketWrapper(message.container, packet), connection);
            }
        } else {
            throw new RegistrationException(String.valueOf(packet.getClass()) + "{} packet not registered on the client, packets need to be registered on both sides!");
        }
    }

    @Override
    public <T> void sendToClient(T packet, ServerPlayer player, boolean ignoreCheck) {
        Message<?> message = this.CHANNELS.get(packet.getClass());
        if (message != null) {
            Channel<CustomPacketPayload> channel = message.channel();
            Connection connection = player.connection.getConnection();
            if (ignoreCheck || channel.isRemotePresent(connection)) {
                channel.send(new CommonPacketWrapper(message.container, packet), connection);
            }
        } else {
            throw new RegistrationException(String.valueOf(packet.getClass()) + "{} packet not registered on the server, packets need to be registered on both sides!");
        }
    }

    @Override
    public <T> void send(T packet, Connection connection) {
        Message<?> message = this.CHANNELS.get(packet.getClass());
        if (message != null) {
            Channel<CustomPacketPayload> channel = message.channel();
            channel.send(new CommonPacketWrapper(message.container, packet), connection);
        }
    }

    private static void handle(CustomPacketPayload customPacketPayload, CustomPayloadEvent.Context ctx) {
    }

    private <T> BiConsumer<T, CustomPayloadEvent.Context> buildHandler(Consumer<PacketContext<T>> handler) {
        return (message, ctx) -> {
            try {
                ctx.setPacketHandled(true);
                ctx.enqueueWork(() -> {
                    Side side = ctx.isServerSide() ? Side.SERVER : Side.CLIENT;
                    ServerPlayer player = ctx.getSender();
                    handler.accept(new PacketContext<Object>(player, message, side));
                });
            }
            catch (Throwable t) {
                Constants.LOG.error("{} error handling packet", message.getClass(), (Object)t);
            }
        };
    }

    public record Message<T>(Channel<CustomPacketPayload> channel, PacketContainer<T> container) {
    }
}

