package commonnetwork;

import commonnetwork.networking.DelayedPacketRegistrationHandler;
import commonnetwork.networking.PacketRegistrar;
import commonnetwork.networking.PacketRegistrationHandler;
import commonnetwork.networking.data.PacketContext;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class CommonNetworkMod
{
    private final PacketRegistrationHandler packetRegistration;
    private static DelayedPacketRegistrationHandler delayedHandler;
    public static CommonNetworkMod INSTANCE;

    public CommonNetworkMod(PacketRegistrationHandler packetRegistration)
    {
        INSTANCE = this;
        this.packetRegistration = packetRegistration;
        getDelayedHandler().registerQueuedPackets(packetRegistration);
    }

    /**
     * Fabric does not enforce load order, so we may have to delay packet registrations.
     *
     * @return the handler;
     */
    private static DelayedPacketRegistrationHandler getDelayedHandler()
    {
        if (delayedHandler == null)
        {
            delayedHandler = new DelayedPacketRegistrationHandler();
        }
        return delayedHandler;
    }

    @Deprecated(forRemoval = true)
    public static <T> PacketRegistrar registerPacket(class_2960 packetIdentifier, Class<T> packetClass, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, Consumer<PacketContext<T>> handler)
    {
        if (INSTANCE != null)
        {
            return INSTANCE.packetRegistration.registerPacket(packetIdentifier, packetClass, encoder, decoder, handler);
        }
        else
        {
            return getDelayedHandler().registerPacket(packetIdentifier, packetClass, encoder, decoder, handler);
        }
    }

    public static <T> PacketRegistrar registerPacket(class_8710.class_9154<? extends class_8710> type, Class<T> packetClass, class_9139<? extends class_2540, T> codec, Consumer<PacketContext<T>> handler)
    {
        if (INSTANCE != null)
        {
            return INSTANCE.packetRegistration.registerPacket(type, packetClass, codec, handler);
        }
        else
        {
            return getDelayedHandler().registerPacket(type, packetClass, codec, handler);
        }
    }

    public static <T> PacketRegistrar registerConfigurationPacket(class_8710.class_9154<? extends class_8710> type, Class<T> packetClass, class_9139<? extends class_2540, T> codec, Consumer<PacketContext<T>> handler)
    {
        if (INSTANCE != null)
        {
            return INSTANCE.packetRegistration.registerConfigurationPacket(type, packetClass, codec, handler);
        }
        else
        {
            return getDelayedHandler().registerConfigurationPacket(type, packetClass, codec, handler);
        }
    }

    public PacketRegistrationHandler getPacketRegistration()
    {
        return packetRegistration;
    }
}
