package commonnetwork.api;

import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2535;
import net.minecraft.class_2818;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import java.util.List;

public class Dispatcher
{
    /**
     * Sends the packet to the server, if the server has the packet registered.
     *
     * @param packet - the packet
     * @param <T>    - The type
     */
    public static <T> void sendToServer(T packet)
    {
        Network.getNetworkHandler().sendToServer(packet);
    }

    /**
     * Sends the packet to the server. Can ignore the check if the server has the packet registered.
     * Likely use case for this is talking to bukkit/spigot/paper servers.
     *
     * @param packet      - the packet
     * @param ignoreCheck - ignore the check if the server has the packet registered.
     * @param <T>         - The type
     */
    public static <T> void sendToServer(T packet, boolean ignoreCheck)
    {
        Network.getNetworkHandler().sendToServer(packet, ignoreCheck);
    }

    /**
     * Sends the packet to the connection.
     *
     * @param packet     - the packet
     * @param connection - the connection
     * @param <T>        - The packet
     */
    public static <T> void send(T packet, class_2535 connection)
    {
        Network.getNetworkHandler().send(packet, connection);
    }

    /**
     * Sends the packet to the client player, only if the player has the packet registered.
     *
     * @param packet - the packet
     * @param player - the player
     * @param <T>    - The type
     */
    public static <T> void sendToClient(T packet, class_3222 player)
    {
        Network.getNetworkHandler().sendToClient(packet, player);
    }

    /**
     * Sends the packet to the client players, only if the players has the packet registered.
     *
     * @param packet  - the packet
     * @param players - the players
     * @param <T>     - The type
     */
    public static <T> void sendToClients(T packet, List<class_3222> players)
    {
        for (class_3222 player : players)
        {
            sendToClient(packet, player);
        }
    }

    /**
     * Sends the packet to all the client players in the server, only if the players has the packet registered.
     *
     * @param packet - the packet
     * @param server - the server
     * @param <T>    - The type
     */
    public static <T> void sendToAllClients(T packet, MinecraftServer server)
    {
        sendToClients(packet, server.method_3760().method_14571());
    }

    /**
     * Sends the packet to all the client players in the level, only if the players has the packet registered.
     *
     * @param packet - the packet
     * @param level  - the level
     * @param <T>    - The type
     */
    public static <T> void sendToClientsInLevel(T packet, class_3218 level)
    {
        sendToClients(packet, level.method_18456());
    }

    /**
     * Sends the packet to all the client players loading a chunk, only if the players has the packet registered.
     *
     * @param packet - the packet
     * @param chunk  - the chunk
     * @param <T>    - The type
     */
    public static <T> void sendToClientsLoadingChunk(T packet, class_2818 chunk)
    {
        class_3215 chunkCache = (class_3215) chunk.method_12200().method_8398();
        sendToClients(packet, chunkCache.field_17254.method_17210(chunk.method_12004(), false));
    }


    /**
     * Sends the packet to all the client players loading a position, only if the players has the packet registered.
     *
     * @param packet - the packet
     * @param level  - the level
     * @param pos    - the chunkpos
     * @param <T>    - The type
     */
    public static <T> void sendToClientsLoadingPos(T packet, class_3218 level, class_1923 pos)
    {
        sendToClientsLoadingChunk(packet, level.method_8497(pos.field_9181, pos.field_9180));
    }

    /**
     * Sends the packet to all the client players loading a position, only if the players has the packet registered.
     *
     * @param packet - the packet
     * @param level  - the level
     * @param pos    - the blockpos
     * @param <T>    - The type
     */
    public static <T> void sendToClientsLoadingPos(T packet, class_3218 level, class_2338 pos)
    {
        sendToClientsLoadingPos(packet, level, new class_1923(pos));
    }

    /**
     * Sends the packet to all the client players in range of a position, only if the players has the packet registered.
     *
     * @param packet - the packet
     * @param level  - the level
     * @param pos    - the blockpos
     * @param range  - the range
     * @param <T>    - The type
     */
    public static <T> void sendToClientsInRange(T packet, class_3218 level, class_2338 pos, double range)
    {
        for (class_3222 player : level.method_18456())
        {
            if (player.method_5649(pos.method_10263(), pos.method_10264(), pos.method_10260()) <= range * range)
            {
                sendToClient(packet, player);
            }
        }
    }
}
