/*
 * Decompiled with CFR 0.152.
 */
package commonnetwork.networking;

import commonnetwork.api.NetworkHandler;
import commonnetwork.networking.PacketRegistrar;
import commonnetwork.networking.data.PacketContainer;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public abstract class PacketRegistrationHandler
implements NetworkHandler,
PacketRegistrar {
    final Map<Class<?>, PacketContainer<?>> PACKET_MAP = new HashMap();
    protected final Side side;

    public PacketRegistrationHandler(Side side) {
        this.side = side;
    }

    @Override
    public <T> PacketRegistrar registerPacket(ResourceLocation packetIdentifier, Class<T> packetClass, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, Consumer<PacketContext<T>> handler) {
        PacketContainer<T> container = new PacketContainer<T>(packetIdentifier, packetClass, encoder, decoder, handler);
        this.PACKET_MAP.put(packetClass, container);
        this.registerPacket(container);
        return this;
    }

    @Override
    public <T> PacketRegistrar registerConfigurationPacket(CustomPacketPayload.Type<? extends CustomPacketPayload> type, Class<T> packetClass, StreamCodec<? extends FriendlyByteBuf, T> codec, Consumer<PacketContext<T>> handler) {
        PacketContainer<T> container = new PacketContainer<T>(type, packetClass, codec, handler, PacketContainer.PacketType.CONFIGURATION);
        this.PACKET_MAP.put(packetClass, container);
        this.registerPacket(container);
        return this;
    }

    @Override
    public <T> PacketRegistrar registerPacket(CustomPacketPayload.Type<? extends CustomPacketPayload> type, Class<T> packetClass, StreamCodec<? extends FriendlyByteBuf, T> codec, Consumer<PacketContext<T>> handler) {
        PacketContainer<T> container = new PacketContainer<T>(type, packetClass, codec, handler, PacketContainer.PacketType.PLAY);
        this.PACKET_MAP.put(packetClass, container);
        this.registerPacket(container);
        return this;
    }

    @Override
    public Side getSide() {
        return this.side;
    }

    abstract <T> void registerPacket(PacketContainer<T> var1);
}

