/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.furnace;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IItemRegistry;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.plugins.vanilla.furnace.FuelRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.oredict.OreDictionary;

public class FuelRecipeMaker {
    @Nonnull
    public static List<FuelRecipe> getFuelRecipes(@Nonnull IItemRegistry itemRegistry, @Nonnull IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        IStackHelper stackHelper = helpers.getStackHelper();
        ImmutableList<ItemStack> fuelStacks = itemRegistry.getFuels();
        HashSet<String> oreDictNames = new HashSet<String>();
        ArrayList<FuelRecipe> fuelRecipes = new ArrayList<FuelRecipe>(fuelStacks.size());
        for (ItemStack fuelStack : fuelStacks) {
            if (fuelStack == null) continue;
            int[] oreIDs = OreDictionary.getOreIDs((ItemStack)fuelStack);
            if (oreIDs.length > 0) {
                for (int oreID : oreIDs) {
                    String name = OreDictionary.getOreName((int)oreID);
                    if (oreDictNames.contains(name)) continue;
                    oreDictNames.add(name);
                    List oreDictFuels = OreDictionary.getOres((String)name);
                    List<ItemStack> oreDictFuelsSet = stackHelper.getAllSubtypes(oreDictFuels);
                    FuelRecipeMaker.removeNoBurnTime(oreDictFuelsSet);
                    if (oreDictFuels.isEmpty()) continue;
                    int burnTime = FuelRecipeMaker.getBurnTime((ItemStack)oreDictFuels.get(0));
                    fuelRecipes.add(new FuelRecipe(guiHelper, oreDictFuelsSet, burnTime));
                }
                continue;
            }
            List<ItemStack> fuels = stackHelper.getSubtypes(fuelStack);
            FuelRecipeMaker.removeNoBurnTime(fuels);
            if (fuels.isEmpty()) continue;
            int burnTime = FuelRecipeMaker.getBurnTime(fuels.get(0));
            fuelRecipes.add(new FuelRecipe(guiHelper, fuels, burnTime));
        }
        return fuelRecipes;
    }

    private static void removeNoBurnTime(Collection<ItemStack> itemStacks) {
        Iterator<ItemStack> iterator = itemStacks.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = iterator.next();
            if (FuelRecipeMaker.getBurnTime(itemStack) != 0) continue;
            iterator.remove();
        }
    }

    private static int getBurnTime(ItemStack itemStack) {
        return TileEntityFurnace.func_145952_a((ItemStack)itemStack);
    }
}

