/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla;

import javax.annotation.Nonnull;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IItemRegistry;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeCategory;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeHandler;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeMaker;
import mezz.jei.plugins.vanilla.crafting.CraftingRecipeCategory;
import mezz.jei.plugins.vanilla.crafting.ShapedOreRecipeHandler;
import mezz.jei.plugins.vanilla.crafting.ShapedRecipesHandler;
import mezz.jei.plugins.vanilla.crafting.ShapelessOreRecipeHandler;
import mezz.jei.plugins.vanilla.crafting.ShapelessRecipesHandler;
import mezz.jei.plugins.vanilla.crafting.TippedArrowRecipeHandler;
import mezz.jei.plugins.vanilla.crafting.TippedArrowRecipeMaker;
import mezz.jei.plugins.vanilla.furnace.FuelRecipeHandler;
import mezz.jei.plugins.vanilla.furnace.FuelRecipeMaker;
import mezz.jei.plugins.vanilla.furnace.FurnaceFuelCategory;
import mezz.jei.plugins.vanilla.furnace.FurnaceSmeltingCategory;
import mezz.jei.plugins.vanilla.furnace.SmeltingRecipeHandler;
import mezz.jei.plugins.vanilla.furnace.SmeltingRecipeMaker;
import net.minecraft.client.gui.inventory.GuiBrewingStand;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.gui.inventory.GuiFurnace;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerBrewingStand;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;

@JEIPlugin
public class VanillaPlugin
extends BlankModPlugin {
    @Override
    public void register(@Nonnull IModRegistry registry) {
        IItemRegistry itemRegistry = registry.getItemRegistry();
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        jeiHelpers.getNbtIgnoreList().ignoreNbtTagNames("AttributeModifiers", "CanDestroy", "CanPlaceOn", "display", "HideFlags", "RepairCost", "Unbreakable");
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new CraftingRecipeCategory(guiHelper), new FurnaceFuelCategory(guiHelper), new FurnaceSmeltingCategory(guiHelper), new BrewingRecipeCategory(guiHelper));
        registry.addRecipeHandlers(new ShapedOreRecipeHandler(), new ShapedRecipesHandler(), new ShapelessOreRecipeHandler(guiHelper), new ShapelessRecipesHandler(guiHelper), new TippedArrowRecipeHandler(), new FuelRecipeHandler(), new SmeltingRecipeHandler(), new BrewingRecipeHandler());
        registry.addRecipeClickArea(GuiCrafting.class, 88, 32, 28, 23, "minecraft.crafting");
        registry.addRecipeClickArea(GuiBrewingStand.class, 97, 16, 14, 30, "minecraft.brewing");
        registry.addRecipeClickArea(GuiFurnace.class, 78, 32, 28, 23, "minecraft.smelting", "minecraft.fuel");
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler(ContainerWorkbench.class, "minecraft.crafting", 1, 9, 10, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerFurnace.class, "minecraft.smelting", 0, 1, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerFurnace.class, "minecraft.fuel", 1, 1, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerBrewingStand.class, "minecraft.brewing", 0, 4, 4, 36);
        registry.addRecipeCategoryCraftingItem(new ItemStack(Blocks.field_150462_ai), "minecraft.crafting");
        registry.addRecipeCategoryCraftingItem(new ItemStack(Blocks.field_150460_al), "minecraft.smelting", "minecraft.fuel");
        registry.addRecipeCategoryCraftingItem(new ItemStack(Items.field_151067_bt), "minecraft.brewing");
        registry.addRecipes(CraftingManager.func_77594_a().func_77592_b());
        registry.addRecipes(SmeltingRecipeMaker.getFurnaceRecipes(jeiHelpers));
        registry.addRecipes(FuelRecipeMaker.getFuelRecipes(itemRegistry, jeiHelpers));
        registry.addRecipes(BrewingRecipeMaker.getBrewingRecipes(itemRegistry));
        registry.addRecipes(TippedArrowRecipeMaker.getTippedArrowRecipes());
    }
}

