/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.RecipeRegistry;
import mezz.jei.config.Config;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.Focus;
import mezz.jei.gui.ItemListOverlay;
import mezz.jei.gui.RecipeClickableArea;
import mezz.jei.gui.RecipesGui;
import mezz.jei.input.GuiContainerWrapper;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.util.Commands;
import mezz.jei.util.MouseHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiRepair;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class InputHandler {
    @Nonnull
    private final RecipesGui recipesGui;
    @Nonnull
    private final ItemListOverlay itemListOverlay;
    @Nonnull
    private final MouseHelper mouseHelper;
    @Nonnull
    private final List<IShowsRecipeFocuses> showsRecipeFocuses = new ArrayList<IShowsRecipeFocuses>();
    private boolean clickHandled = false;

    public InputHandler(@Nonnull RecipesGui recipesGui, @Nonnull ItemListOverlay itemListOverlay) {
        this.recipesGui = recipesGui;
        this.itemListOverlay = itemListOverlay;
        this.mouseHelper = new MouseHelper();
        this.showsRecipeFocuses.add(recipesGui);
        this.showsRecipeFocuses.add(itemListOverlay);
        this.showsRecipeFocuses.add(new GuiContainerWrapper());
    }

    public boolean handleMouseEvent(@Nonnull GuiScreen guiScreen, int mouseX, int mouseY) {
        boolean cancelEvent = false;
        if (Mouse.getEventButton() > -1) {
            if (Mouse.getEventButtonState()) {
                if (!this.clickHandled) {
                    this.clickHandled = cancelEvent = this.handleMouseClick(guiScreen, Mouse.getEventButton(), mouseX, mouseY);
                }
            } else if (this.clickHandled) {
                this.clickHandled = false;
                cancelEvent = true;
            }
        } else if (Mouse.getEventDWheel() != 0) {
            cancelEvent = this.handleMouseScroll(Mouse.getEventDWheel(), mouseX, mouseY);
        }
        return cancelEvent;
    }

    private boolean handleMouseScroll(int dWheel, int mouseX, int mouseY) {
        return this.itemListOverlay.handleMouseScrolled(mouseX, mouseY, dWheel);
    }

    private boolean handleMouseClick(@Nonnull GuiScreen guiScreen, int mouseButton, int mouseX, int mouseY) {
        if (this.itemListOverlay.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        Focus focus = this.getFocusUnderMouseForClick(mouseX, mouseY);
        if (focus != null && this.handleMouseClickedFocus(mouseButton, focus)) {
            return true;
        }
        if (guiScreen instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)guiScreen;
            RecipeRegistry recipeRegistry = Internal.getRuntime().getRecipeRegistry();
            RecipeClickableArea clickableArea = recipeRegistry.getRecipeClickableArea(guiContainer, mouseX - guiContainer.field_147003_i, mouseY - guiContainer.field_147009_r);
            if (clickableArea != null) {
                List<String> recipeCategoryUids = clickableArea.getRecipeCategoryUids();
                this.recipesGui.showCategories(recipeCategoryUids);
            }
        }
        return false;
    }

    @Nullable
    private Focus getFocusUnderMouseForClick(int mouseX, int mouseY) {
        for (IShowsRecipeFocuses gui : this.showsRecipeFocuses) {
            Focus focus;
            if (!gui.canSetFocusWithMouse() || (focus = gui.getFocusUnderMouse(mouseX, mouseY)) == null) continue;
            return focus;
        }
        return null;
    }

    @Nullable
    private Focus getFocusUnderMouseForKey(int mouseX, int mouseY) {
        for (IShowsRecipeFocuses gui : this.showsRecipeFocuses) {
            Focus focus = gui.getFocusUnderMouse(mouseX, mouseY);
            if (focus == null) continue;
            return focus;
        }
        return null;
    }

    private boolean handleMouseClickedFocus(int mouseButton, @Nonnull Focus focus) {
        if (Config.isEditModeEnabled() && this.handleClickEditStack(mouseButton, focus)) {
            return true;
        }
        if (Config.isCheatItemsEnabled() && focus.getStack() != null && focus.allowsCheating()) {
            if (mouseButton == 0) {
                Commands.giveFullStack(focus.getStack());
                return true;
            }
            if (mouseButton == 1) {
                Commands.giveOneFromStack(focus.getStack());
                return true;
            }
        }
        if (mouseButton == 0) {
            this.recipesGui.showRecipes(focus);
            return true;
        }
        if (mouseButton == 1) {
            this.recipesGui.showUses(focus);
            return true;
        }
        return false;
    }

    private boolean handleClickEditStack(int mouseButton, @Nonnull Focus focus) {
        ItemStack itemStack = focus.getStack();
        if (itemStack == null) {
            return false;
        }
        Config.ItemBlacklistType blacklistType = null;
        if (GuiScreen.func_146271_m()) {
            if (GuiScreen.func_146272_n()) {
                if (mouseButton == 0) {
                    blacklistType = Config.ItemBlacklistType.MOD_ID;
                }
            } else if (mouseButton == 0) {
                blacklistType = Config.ItemBlacklistType.ITEM;
            } else if (mouseButton == 1) {
                blacklistType = Config.ItemBlacklistType.WILDCARD;
            }
        }
        if (blacklistType == null) {
            return false;
        }
        if (Config.isItemOnConfigBlacklist(focus.getStack(), blacklistType)) {
            Config.removeItemFromConfigBlacklist(focus.getStack(), blacklistType);
        } else {
            Config.addItemToConfigBlacklist(focus.getStack(), blacklistType);
        }
        return true;
    }

    public boolean handleKeyEvent() {
        boolean cancelEvent = false;
        if (Keyboard.getEventKeyState()) {
            int eventKey = Keyboard.getEventKey();
            cancelEvent = this.handleKeyDown(eventKey);
        }
        return cancelEvent;
    }

    private boolean handleKeyDown(int eventKey) {
        if (this.itemListOverlay.isOpen() && this.itemListOverlay.hasKeyboardFocus()) {
            if (InputHandler.isInventoryCloseKey(eventKey) || InputHandler.isEnterKey(eventKey)) {
                this.itemListOverlay.setKeyboardFocus(false);
                return true;
            }
            if (this.itemListOverlay.onKeyPressed(eventKey)) {
                return true;
            }
        }
        if (KeyBindings.toggleOverlay.isActiveAndMatches(eventKey)) {
            Config.toggleOverlayEnabled();
            return false;
        }
        if (this.itemListOverlay.isOpen() && KeyBindings.focusSearch.isActiveAndMatches(eventKey)) {
            this.itemListOverlay.setKeyboardFocus(true);
            return true;
        }
        if (!this.isContainerTextFieldFocused()) {
            Focus focus;
            if (KeyBindings.showRecipe.isActiveAndMatches(eventKey)) {
                Focus focus2 = this.getFocusUnderMouseForKey(this.mouseHelper.getX(), this.mouseHelper.getY());
                if (focus2 != null) {
                    this.recipesGui.showRecipes(focus2);
                    return true;
                }
            } else if (KeyBindings.showUses.isActiveAndMatches(eventKey) && (focus = this.getFocusUnderMouseForKey(this.mouseHelper.getX(), this.mouseHelper.getY())) != null) {
                this.recipesGui.showUses(focus);
                return true;
            }
            if (this.itemListOverlay.isOpen() && this.itemListOverlay.onKeyPressed(eventKey)) {
                return true;
            }
        }
        return false;
    }

    private boolean isContainerTextFieldFocused() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        GuiTextField textField = null;
        if (gui instanceof GuiContainerCreative) {
            textField = ((GuiContainerCreative)gui).field_147062_A;
        } else if (gui instanceof GuiRepair) {
            textField = ((GuiRepair)gui).field_147091_w;
        }
        return textField != null && textField.func_146176_q() && textField.field_146226_p && textField.func_146206_l();
    }

    public static boolean isInventoryToggleKey(int keyCode) {
        return Minecraft.func_71410_x().field_71474_y.field_151445_Q.isActiveAndMatches(keyCode);
    }

    public static boolean isInventoryCloseKey(int keyCode) {
        return keyCode == 1;
    }

    public static boolean isEnterKey(int keyCode) {
        return keyCode == 28;
    }
}

