/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.RecipeRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.util.StackHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class Focus {
    private final ItemStack stack;
    private final Fluid fluid;
    @Nonnull
    private Mode mode = Mode.NONE;
    private boolean allowsCheating = false;

    public Focus() {
        this.stack = null;
        this.fluid = null;
    }

    public Focus(ItemStack stack) {
        this.stack = stack;
        this.fluid = Focus.getFluidFromItemStack(stack);
    }

    public Focus(Fluid fluid) {
        this.stack = null;
        this.fluid = fluid;
    }

    @Nullable
    private static Fluid getFluidFromItemStack(@Nonnull ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem fluidContainerItem = (IFluidContainerItem)item;
            FluidStack fluidStack = fluidContainerItem.getFluid(stack);
            if (fluidStack == null) {
                return null;
            }
            return fluidStack.getFluid();
        }
        if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
            FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            if (fluidStack == null) {
                return null;
            }
            return fluidStack.getFluid();
        }
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            Block block = itemBlock.func_179223_d();
            return FluidRegistry.lookupFluidForBlock((Block)block);
        }
        return null;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean isBlank() {
        return this.stack == null && this.fluid == null;
    }

    public void setMode(@Nonnull Mode mode) {
        this.mode = mode;
    }

    @Nonnull
    public Mode getMode() {
        return this.mode;
    }

    public void setAllowsCheating() {
        this.allowsCheating = true;
    }

    public boolean allowsCheating() {
        return this.allowsCheating;
    }

    public boolean equalsFocus(@Nonnull Focus other) {
        return ItemStack.func_77989_b((ItemStack)this.stack, (ItemStack)other.getStack()) && this.fluid == other.getFluid() && this.mode == other.getMode();
    }

    @Nonnull
    public List<IRecipeCategory> getCategories() {
        RecipeRegistry recipeRegistry = Internal.getRuntime().getRecipeRegistry();
        if (this.mode == Mode.INPUT) {
            return this.getInputCategories(recipeRegistry);
        }
        if (this.mode == Mode.OUTPUT) {
            return this.getOutputCategories(recipeRegistry);
        }
        return recipeRegistry.getRecipeCategories();
    }

    @Nonnull
    private List<IRecipeCategory> getInputCategories(@Nonnull IRecipeRegistry recipeRegistry) {
        if (this.stack != null && this.fluid != null) {
            ArrayList<IRecipeCategory> categories = new ArrayList<IRecipeCategory>(recipeRegistry.getRecipeCategoriesWithInput(this.stack));
            categories.addAll(recipeRegistry.getRecipeCategoriesWithInput(this.fluid));
            return ImmutableSet.copyOf(categories).asList();
        }
        if (this.stack != null) {
            return recipeRegistry.getRecipeCategoriesWithInput(this.stack);
        }
        return recipeRegistry.getRecipeCategoriesWithInput(this.fluid);
    }

    @Nonnull
    private List<IRecipeCategory> getOutputCategories(@Nonnull IRecipeRegistry recipeRegistry) {
        if (this.stack != null && this.fluid != null) {
            ArrayList<IRecipeCategory> categories = new ArrayList<IRecipeCategory>(recipeRegistry.getRecipeCategoriesWithOutput(this.stack));
            categories.addAll(recipeRegistry.getRecipeCategoriesWithOutput(this.fluid));
            return ImmutableSet.copyOf(categories).asList();
        }
        if (this.stack != null) {
            return recipeRegistry.getRecipeCategoriesWithOutput(this.stack);
        }
        return recipeRegistry.getRecipeCategoriesWithOutput(this.fluid);
    }

    @Nonnull
    public List<Object> getRecipes(@Nonnull IRecipeCategory recipeCategory) {
        RecipeRegistry recipeRegistry = Internal.getRuntime().getRecipeRegistry();
        if (this.mode == Mode.INPUT) {
            return this.getInputRecipes(recipeRegistry, recipeCategory);
        }
        if (this.mode == Mode.OUTPUT) {
            return this.getOutputRecipes(recipeRegistry, recipeCategory);
        }
        return recipeRegistry.getRecipes(recipeCategory);
    }

    @Nonnull
    public Collection<ItemStack> getRecipeCategoryCraftingItems(@Nonnull IRecipeCategory recipeCategory) {
        StackHelper stackHelper;
        ItemStack matchingStack;
        RecipeRegistry recipeRegistry = Internal.getRuntime().getRecipeRegistry();
        Collection<ItemStack> craftingItems = recipeRegistry.getCraftingItems(recipeCategory);
        if (this.stack != null && this.mode == Mode.INPUT && (matchingStack = (stackHelper = Internal.getStackHelper()).containsStack(craftingItems, this.stack)) != null) {
            return Collections.singletonList(matchingStack);
        }
        return craftingItems;
    }

    @Nonnull
    private List<Object> getInputRecipes(@Nonnull IRecipeRegistry recipeRegistry, @Nonnull IRecipeCategory recipeCategory) {
        if (this.stack != null && this.fluid != null) {
            ArrayList<Object> recipes = new ArrayList<Object>(recipeRegistry.getRecipesWithInput(recipeCategory, this.stack));
            recipes.addAll(recipeRegistry.getRecipesWithInput(recipeCategory, this.fluid));
            return ImmutableSet.copyOf(recipes).asList();
        }
        if (this.stack != null) {
            return recipeRegistry.getRecipesWithInput(recipeCategory, this.stack);
        }
        return recipeRegistry.getRecipesWithInput(recipeCategory, this.fluid);
    }

    @Nonnull
    private List<Object> getOutputRecipes(@Nonnull IRecipeRegistry recipeRegistry, @Nonnull IRecipeCategory recipeCategory) {
        if (this.stack != null && this.fluid != null) {
            ArrayList<Object> recipes = new ArrayList<Object>(recipeRegistry.getRecipesWithOutput(recipeCategory, this.stack));
            recipes.addAll(recipeRegistry.getRecipesWithOutput(recipeCategory, this.fluid));
            return ImmutableSet.copyOf(recipes).asList();
        }
        if (this.stack != null) {
            return recipeRegistry.getRecipesWithOutput(recipeCategory, this.stack);
        }
        return recipeRegistry.getRecipesWithOutput(recipeCategory, this.fluid);
    }

    public static enum Mode {
        INPUT,
        OUTPUT,
        NONE;

    }
}

