/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.IItemBlacklist;
import mezz.jei.api.IItemRegistry;
import mezz.jei.config.Config;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.ItemStackElement;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemFilter {
    private final LoadingCache<String, ImmutableList<ItemStackElement>> filteredItemMapsCache;

    public ItemFilter(IItemRegistry itemRegistry) {
        this.filteredItemMapsCache = CacheBuilder.newBuilder().maximumWeight(16L).weigher((Weigher)new SearchFilterWeigher()).concurrencyLevel(1).build((CacheLoader)new ItemFilterCacheLoader(itemRegistry));
        this.filteredItemMapsCache.getUnchecked((Object)"");
    }

    public void reset() {
        this.filteredItemMapsCache.invalidateAll();
    }

    @Nonnull
    public String getFilterText() {
        return Config.getFilterText();
    }

    @Nonnull
    public ImmutableList<ItemStackElement> getItemList() {
        String[] filters = this.getFilterText().split("\\|");
        if (filters.length == 1) {
            String filter = filters[0];
            return (ImmutableList)this.filteredItemMapsCache.getUnchecked((Object)filter);
        }
        ImmutableList.Builder itemList = ImmutableList.builder();
        for (String filter : filters) {
            List itemStackElements = (List)this.filteredItemMapsCache.getUnchecked((Object)filter);
            itemList.addAll((Iterable)itemStackElements);
        }
        return itemList.build();
    }

    public int size() {
        return this.getItemList().size();
    }

    private static ImmutableList<ItemStackElement> createBaseList(IItemRegistry itemRegistry) {
        ItemStackChecker itemStackChecker = new ItemStackChecker();
        ImmutableList.Builder baseList = ImmutableList.builder();
        for (ItemStack itemStack : itemRegistry.getItemList()) {
            ItemStackElement itemStackElement;
            if (itemStack == null || itemStackChecker.isItemStackHidden(itemStack) || (itemStackElement = ItemStackElement.create(itemStack)) == null) continue;
            baseList.add((Object)itemStackElement);
        }
        for (Multiset.Entry brokenItem : itemStackChecker.getBrokenItems().entrySet()) {
            int count = brokenItem.getCount();
            if (count <= 1) continue;
            Item item = (Item)brokenItem.getElement();
            String modName = Internal.getItemRegistry().getModNameForItem(item);
            Log.error("Couldn't get ItemModel for {} item {}. Suppressed {} similar errors.", modName, item, count);
        }
        return baseList.build();
    }

    private static class FilterPredicate
    implements Predicate<ItemStackElement> {
        private final List<String> searchTokens = new ArrayList<String>();
        private final List<String> modNameTokens = new ArrayList<String>();
        private final List<String> tooltipTokens = new ArrayList<String>();
        private final List<String> oreDictTokens = new ArrayList<String>();
        private final List<String> creativeTabTokens = new ArrayList<String>();
        private final List<String> colorTokens = new ArrayList<String>();

        public FilterPredicate(String filterText) {
            String[] tokens;
            for (String token : tokens = filterText.split(" ")) {
                if (token.isEmpty()) continue;
                if (token.startsWith("@")) {
                    FilterPredicate.addTokenWithoutPrefix(token, this.modNameTokens);
                    continue;
                }
                if (token.startsWith("#")) {
                    FilterPredicate.addTokenWithoutPrefix(token, this.tooltipTokens);
                    continue;
                }
                if (token.startsWith("$")) {
                    FilterPredicate.addTokenWithoutPrefix(token, this.oreDictTokens);
                    continue;
                }
                if (token.startsWith("%")) {
                    FilterPredicate.addTokenWithoutPrefix(token, this.creativeTabTokens);
                    continue;
                }
                if (token.startsWith("^")) {
                    FilterPredicate.addTokenWithoutPrefix(token, this.colorTokens);
                    continue;
                }
                this.searchTokens.add(token);
            }
        }

        private static void addTokenWithoutPrefix(String token, List<String> tokensList) {
            if (token.length() < 2) {
                return;
            }
            String tokenText = token.substring(1);
            tokensList.add(tokenText);
        }

        public boolean apply(@Nullable ItemStackElement input) {
            if (input == null) {
                return false;
            }
            if (!FilterPredicate.stringContainsTokens(input.getModNameString(), this.modNameTokens)) {
                return false;
            }
            if (!FilterPredicate.stringContainsTokens(input.getTooltipString(), this.tooltipTokens)) {
                return false;
            }
            if (!FilterPredicate.stringContainsTokens(input.getOreDictString(), this.oreDictTokens)) {
                return false;
            }
            if (!FilterPredicate.stringContainsTokens(input.getCreativeTabsString(), this.creativeTabTokens)) {
                return false;
            }
            if (!FilterPredicate.stringContainsTokens(input.getColorString(), this.colorTokens)) {
                return false;
            }
            return FilterPredicate.stringContainsTokens(input.getSearchString(), this.searchTokens);
        }

        private static boolean stringContainsTokens(String comparisonString, List<String> tokens) {
            for (String token : tokens) {
                if (comparisonString.contains(token)) continue;
                return false;
            }
            return true;
        }
    }

    private static class ItemStackChecker {
        private final IItemBlacklist itemBlacklist;
        private final ItemModelMesher itemModelMesher;
        private final IBakedModel missingModel;
        private final Multiset<Item> brokenItems = HashMultiset.create();

        public ItemStackChecker() {
            this.itemBlacklist = Internal.getHelpers().getItemBlacklist();
            this.itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
            this.missingModel = this.itemModelMesher.func_178083_a().func_174951_a();
        }

        public boolean isItemStackHidden(@Nonnull ItemStack itemStack) {
            if (this.isItemHiddenByBlacklist(itemStack)) {
                return true;
            }
            return this.isItemStackHiddenByMissingModel(itemStack);
        }

        public Multiset<Item> getBrokenItems() {
            return this.brokenItems;
        }

        private boolean isItemStackHiddenByMissingModel(@Nonnull ItemStack itemStack) {
            IBakedModel itemModel;
            Item item = itemStack.func_77973_b();
            if (this.brokenItems.contains((Object)item)) {
                return true;
            }
            RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
            try {
                itemModel = renderItem.func_184393_a(itemStack, null, null);
            }
            catch (LinkageError | RuntimeException e) {
                String modName = Internal.getItemRegistry().getModNameForItem(item);
                String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
                Log.error("Couldn't get ItemModel for {} itemStack {}", modName, stackInfo, e);
                this.brokenItems.add((Object)item);
                return true;
            }
            if (Config.isHideMissingModelsEnabled()) {
                return itemModel == null || itemModel == this.missingModel;
            }
            return false;
        }

        private boolean isItemHiddenByBlacklist(@Nonnull ItemStack itemStack) {
            try {
                if (!this.itemBlacklist.isItemBlacklisted(itemStack)) {
                    return false;
                }
            }
            catch (RuntimeException e) {
                String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
                Log.error("Could not check blacklist for stack {}", stackInfo, e);
                return true;
            }
            if (Config.isEditModeEnabled()) {
                return !Config.isItemOnConfigBlacklist(itemStack);
            }
            return true;
        }
    }

    private class ItemFilterCacheLoader
    extends CacheLoader<String, ImmutableList<ItemStackElement>> {
        private final IItemRegistry itemRegistry;

        public ItemFilterCacheLoader(IItemRegistry itemRegistry) {
            this.itemRegistry = itemRegistry;
        }

        public ImmutableList<ItemStackElement> load(@Nonnull String filterText) throws Exception {
            if (filterText.length() == 0) {
                return ItemFilter.createBaseList(this.itemRegistry);
            }
            String prevFilterText = filterText.substring(0, filterText.length() - 1);
            ImmutableList baseItemSet = (ImmutableList)ItemFilter.this.filteredItemMapsCache.get((Object)prevFilterText);
            FilterPredicate filterPredicate = new FilterPredicate(filterText);
            ImmutableList.Builder itemStackElementsBuilder = ImmutableList.builder();
            for (ItemStackElement itemStackElement : baseItemSet) {
                if (!filterPredicate.apply(itemStackElement)) continue;
                itemStackElementsBuilder.add((Object)itemStackElement);
            }
            return itemStackElementsBuilder.build();
        }
    }

    private static class SearchFilterWeigher
    implements Weigher<String, ImmutableList<ItemStackElement>> {
        private SearchFilterWeigher() {
        }

        public int weigh(@Nonnull String key, @Nonnull ImmutableList<ItemStackElement> value) {
            return key.length() == 0 ? 0 : 1;
        }
    }
}

