/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.util.Log;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.oredict.OreDictionary;

public class StackUtil {
    private StackUtil() {
    }

    @Nonnull
    public static List<ItemStack> removeDuplicateItemStacks(@Nonnull Iterable<ItemStack> stacks) {
        ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack == null || StackUtil.containsStack(newStacks, stack) != null) continue;
            newStacks.add(stack);
        }
        return newStacks;
    }

    @Nullable
    public static ItemStack containsStack(@Nullable Iterable<ItemStack> stacks, @Nullable Iterable<ItemStack> contains) {
        if (stacks == null || contains == null) {
            return null;
        }
        for (ItemStack containStack : contains) {
            ItemStack matchingStack = StackUtil.containsStack(stacks, containStack);
            if (matchingStack == null) continue;
            return matchingStack;
        }
        return null;
    }

    @Nullable
    public static ItemStack containsStack(@Nullable Iterable<ItemStack> stacks, @Nullable ItemStack contains) {
        if (stacks == null || contains == null) {
            return null;
        }
        for (ItemStack stack : stacks) {
            if (!StackUtil.isIdentical(contains, stack)) continue;
            return stack;
        }
        return null;
    }

    @Nonnull
    public static List<ItemStack> condenseStacks(Collection<ItemStack> stacks) {
        ArrayList<ItemStack> condensed = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack == null || stack.field_77994_a <= 0) continue;
            boolean matched = false;
            for (ItemStack cached : condensed) {
                if (!cached.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)cached, (ItemStack)stack)) continue;
                cached.field_77994_a += stack.field_77994_a;
                matched = true;
            }
            if (matched) continue;
            ItemStack cached = stack.func_77946_l();
            condensed.add(cached);
        }
        return condensed;
    }

    @Nullable
    public static List<ItemStack> containsSets(Collection<ItemStack> required, Collection<ItemStack> offered) {
        int totalSets = 0;
        ArrayList<ItemStack> matching = new ArrayList<ItemStack>();
        List<ItemStack> condensedRequired = StackUtil.condenseStacks(required);
        List<ItemStack> condensedOffered = StackUtil.condenseStacks(offered);
        for (ItemStack req : condensedRequired) {
            int reqCount = 0;
            for (ItemStack offer : condensedOffered) {
                if (!StackUtil.isIdentical(req, offer)) continue;
                int stackCount = offer.field_77994_a / req.field_77994_a;
                reqCount = Math.max(reqCount, stackCount);
            }
            if (reqCount == 0) {
                return null;
            }
            matching.add(req);
            if (totalSets != 0 && totalSets <= reqCount) continue;
            totalSets = reqCount;
        }
        return matching;
    }

    public static boolean isIdentical(@Nullable ItemStack lhs, @Nullable ItemStack rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.func_77973_b() != rhs.func_77973_b()) {
            return false;
        }
        if (lhs.func_77960_j() != Short.MAX_VALUE && lhs.func_77960_j() != rhs.func_77960_j()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)lhs, (ItemStack)rhs);
    }

    @Nonnull
    public static List<ItemStack> getSubtypes(@Nonnull ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return Collections.emptyList();
        }
        if (item.getMetadata(itemStack) != Short.MAX_VALUE) {
            return Collections.singletonList(itemStack);
        }
        return StackUtil.getSubtypes(item);
    }

    @Nonnull
    public static List<ItemStack> getSubtypes(@Nonnull Item item) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        ArrayList subItems = new ArrayList();
        for (CreativeTabs itemTab : item.getCreativeTabs()) {
            subItems.clear();
            item.func_150895_a(item, itemTab, subItems);
            itemStacks.addAll(subItems);
        }
        if (itemStacks.isEmpty()) {
            ItemStack stack = new ItemStack(item);
            itemStacks.add(stack);
        }
        return itemStacks;
    }

    public static List<ItemStack> getAllSubtypes(Iterable stacks) {
        ArrayList<ItemStack> allSubtypes = new ArrayList<ItemStack>();
        StackUtil.getAllSubtypes(allSubtypes, stacks);
        return allSubtypes;
    }

    private static void getAllSubtypes(List<ItemStack> subtypesList, Iterable stacks) {
        for (Object obj : stacks) {
            if (obj instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)obj;
                List<ItemStack> subtypes = StackUtil.getSubtypes(itemStack);
                subtypesList.addAll(subtypes);
                continue;
            }
            if (obj instanceof Iterable) {
                StackUtil.getAllSubtypes(subtypesList, (Iterable)obj);
                continue;
            }
            if (obj == null) continue;
            Log.error("Unknown object found: {}", obj);
        }
    }

    @Nonnull
    public static List<ItemStack> toItemStackList(@Nullable Object stacks) {
        ArrayList<ItemStack> itemStacksList = new ArrayList<ItemStack>();
        StackUtil.toItemStackList(itemStacksList, stacks);
        return StackUtil.removeDuplicateItemStacks(itemStacksList);
    }

    private static void toItemStackList(@Nonnull List<ItemStack> itemStackList, @Nullable Object input) {
        if (input instanceof ItemStack) {
            itemStackList.add((ItemStack)input);
        } else if (input instanceof String) {
            List stacks = OreDictionary.getOres((String)((String)input));
            itemStackList.addAll(stacks);
        } else if (input instanceof Iterable) {
            for (Object obj : (Iterable)input) {
                StackUtil.toItemStackList(itemStackList, obj);
            }
        } else if (input != null) {
            Log.error("Unknown object found: {}", input);
        }
    }

    @Nonnull
    public static String getUniqueIdentifierForStack(@Nonnull ItemStack stack) {
        return StackUtil.getUniqueIdentifierForStack(stack, false);
    }

    @Nonnull
    public static String getUniqueIdentifierForStack(@Nonnull ItemStack stack, boolean wildcard) {
        Item item = stack.func_77973_b();
        if (item == null) {
            throw new NullPointerException("Found an itemStack with a null item. This is an error from another mod.");
        }
        FMLControlledNamespacedRegistry itemRegistry = GameData.getItemRegistry();
        ResourceLocation itemName = itemRegistry.getNameForObject((Object)item);
        if (itemName == null) {
            throw new NullPointerException("No name for item in GameData itemRegistry: " + item.getClass());
        }
        String itemNameString = itemName.toString();
        int metadata = stack.func_77960_j();
        if (wildcard || metadata == Short.MAX_VALUE) {
            return itemNameString;
        }
        StringBuilder itemKey = new StringBuilder(itemNameString).append(':').append(metadata);
        if (stack.func_77942_o()) {
            NBTTagCompound nbtTagCompound = stack.func_77978_p();
            if (!(nbtTagCompound = StackUtil.cleanNbt(nbtTagCompound)).func_82582_d()) {
                itemKey.append(':').append(nbtTagCompound);
            }
        }
        return itemKey.toString();
    }

    @Nonnull
    public static List<String> getUniqueIdentifiersWithWildcard(@Nonnull ItemStack itemStack) {
        return Arrays.asList(StackUtil.getUniqueIdentifierForStack(itemStack, false), StackUtil.getUniqueIdentifierForStack(itemStack, true));
    }

    private static NBTTagCompound cleanNbt(NBTTagCompound nbtTagCompound) {
        Set keys = nbtTagCompound.func_150296_c();
        Set<String> ignoredKeys = Internal.getHelpers().getNbtIgnoreList().getIgnoredNbtTags(keys);
        if (ignoredKeys.isEmpty()) {
            return nbtTagCompound;
        }
        NBTTagCompound nbtTagCompoundCopy = (NBTTagCompound)nbtTagCompound.func_74737_b();
        for (String ignoredKey : ignoredKeys) {
            nbtTagCompoundCopy.func_82580_o(ignoredKey);
        }
        return nbtTagCompoundCopy;
    }

    public static int addStack(Container container, Collection<Integer> slotIndexes, ItemStack stack, boolean doAdd) {
        ItemStack inventoryStack;
        Slot slot;
        int added = 0;
        for (Integer slotIndex : slotIndexes) {
            slot = container.func_75139_a(slotIndex.intValue());
            if (slot == null || (inventoryStack = slot.func_75211_c()) == null || inventoryStack.func_77973_b() == null || !inventoryStack.func_77985_e() || !inventoryStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)inventoryStack, (ItemStack)stack)) continue;
            int remain = stack.field_77994_a - added;
            int space = inventoryStack.func_77976_d() - inventoryStack.field_77994_a;
            if (space <= 0) continue;
            if (space >= remain) {
                if (doAdd) {
                    inventoryStack.field_77994_a += remain;
                }
                return stack.field_77994_a;
            }
            if (doAdd) {
                inventoryStack.field_77994_a = inventoryStack.func_77976_d();
            }
            added += space;
        }
        if (added >= stack.field_77994_a) {
            return added;
        }
        for (Integer slotIndex : slotIndexes) {
            slot = container.func_75139_a(slotIndex.intValue());
            if (slot == null || (inventoryStack = slot.func_75211_c()) != null) continue;
            if (doAdd) {
                ItemStack stackToAdd = stack.func_77946_l();
                stackToAdd.field_77994_a = stack.field_77994_a - added;
                slot.func_75215_d(stackToAdd);
            }
            return stack.field_77994_a;
        }
        return added;
    }
}

