/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.config.Config;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameData;

public class ItemStackElement {
    @Nonnull
    private final ItemStack itemStack;
    @Nonnull
    private final String searchString;
    @Nonnull
    private final String modName;

    @Nullable
    public static ItemStackElement create(@Nonnull ItemStack itemStack) {
        try {
            return new ItemStackElement(itemStack);
        }
        catch (RuntimeException e) {
            Log.warning("Found broken itemStack.", e);
            return null;
        }
    }

    private ItemStackElement(@Nonnull ItemStack itemStack) {
        this.itemStack = itemStack;
        ResourceLocation itemResourceLocation = GameData.getItemRegistry().getNameForObject((Object)itemStack.func_77973_b());
        String modId = itemResourceLocation.func_110624_b().toLowerCase(Locale.ENGLISH);
        String modName = Internal.getItemRegistry().getModNameForItem(itemStack.func_77973_b()).toLowerCase(Locale.ENGLISH);
        String displayName = itemStack.func_82833_r();
        if (displayName == null) {
            throw new NullPointerException("No display name for item. " + itemResourceLocation.toString() + " " + itemStack.func_77973_b().getClass());
        }
        String searchString = displayName.toLowerCase();
        this.modName = modId + ' ' + modName;
        this.searchString = Config.isAtPrefixRequiredForModName() ? searchString : searchString + ' ' + this.modName;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Nonnull
    public String getSearchString() {
        return this.searchString;
    }

    @Nonnull
    public String getModName() {
        return this.modName;
    }
}

