/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.transfer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.JustEnoughItems;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.config.Config;
import mezz.jei.gui.RecipeLayout;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.network.packets.PacketRecipeTransfer;
import mezz.jei.transfer.RecipeTransferHandlerHelper;
import mezz.jei.util.Log;
import mezz.jei.util.StackUtil;
import mezz.jei.util.Translator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class BasicRecipeTransferHandler
implements IRecipeTransferHandler {
    @Nonnull
    private final IRecipeTransferInfo transferHelper;

    public BasicRecipeTransferHandler(@Nonnull IRecipeTransferInfo transferHelper) {
        this.transferHelper = transferHelper;
    }

    @Override
    public Class<? extends Container> getContainerClass() {
        return this.transferHelper.getContainerClass();
    }

    @Override
    public String getRecipeCategoryUid() {
        return this.transferHelper.getRecipeCategoryUid();
    }

    @Override
    public IRecipeTransferError transferRecipe(@Nonnull Container container, @Nonnull RecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean doTransfer) {
        RecipeTransferHandlerHelper handlerHelper = Internal.getHelpers().recipeTransferHandlerHelper();
        if (!Config.isJeiOnServer()) {
            return handlerHelper.createInternalError();
        }
        HashMap<Integer, Slot> inventorySlots = new HashMap<Integer, Slot>();
        for (Slot slot : this.transferHelper.getInventorySlots(container)) {
            inventorySlots.put(slot.field_75222_d, slot);
        }
        HashMap<Integer, Slot> craftingSlots = new HashMap<Integer, Slot>();
        for (Slot slot : this.transferHelper.getRecipeSlots(container)) {
            craftingSlots.put(slot.field_75222_d, slot);
        }
        IRecipeWrapper iRecipeWrapper = recipeLayout.getRecipeWrapper();
        if (iRecipeWrapper.getInputs().size() > craftingSlots.size()) {
            Log.error("Recipe Transfer helper {} does not work for container {}", this.transferHelper.getClass(), container.getClass());
            return handlerHelper.createInternalError();
        }
        GuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        List<List<ItemStack>> requiredStackLists = BasicRecipeTransferHandler.getInputStacks(itemStackGroup.getGuiIngredients());
        ArrayList<ItemStack> availableItemStacks = new ArrayList<ItemStack>();
        int filledCraftSlotCount = 0;
        int emptySlotCount = 0;
        for (Slot slot : craftingSlots.values()) {
            if (!slot.func_75216_d()) continue;
            if (!slot.func_82869_a(player)) {
                Log.error("Recipe Transfer helper {} does not work for container {}. Player can't move item out of Crafting Slot number {}", this.transferHelper.getClass(), container.getClass(), slot.field_75222_d);
                return handlerHelper.createInternalError();
            }
            ++filledCraftSlotCount;
            availableItemStacks.add(slot.func_75211_c());
        }
        for (Slot slot : inventorySlots.values()) {
            if (slot.func_75216_d()) {
                availableItemStacks.add(slot.func_75211_c());
                continue;
            }
            ++emptySlotCount;
        }
        if (filledCraftSlotCount - iRecipeWrapper.getInputs().size() > emptySlotCount) {
            String message = Translator.translateToLocal("jei.tooltip.error.recipe.transfer.inventory.full");
            return handlerHelper.createUserErrorWithTooltip(message);
        }
        MatchingItemsResult matchingItemsResult = BasicRecipeTransferHandler.getMatchingItems(availableItemStacks, requiredStackLists);
        if (matchingItemsResult.missingItems.size() > 0) {
            HashSet<Integer> missingIngredientIndexes = new HashSet<Integer>();
            block4: for (Map.Entry guiIngredientEntry : itemStackGroup.getGuiIngredients().entrySet()) {
                GuiIngredient guiIngredient = (GuiIngredient)guiIngredientEntry.getValue();
                for (List<ItemStack> missingIngredients : matchingItemsResult.missingItems) {
                    if (StackUtil.containsStack(guiIngredient.getAll(), missingIngredients) == null) continue;
                    missingIngredientIndexes.add(guiIngredientEntry.getKey());
                    continue block4;
                }
            }
            String message = Translator.translateToLocal("jei.tooltip.error.recipe.transfer.missing");
            return handlerHelper.createUserErrorForSlots(message, missingIngredientIndexes);
        }
        Map<Integer, ItemStack> slotMap = BasicRecipeTransferHandler.buildSlotMap(itemStackGroup, matchingItemsResult.matchingItems);
        if (slotMap == null || StackUtil.containsSets(slotMap.values(), availableItemStacks) == null) {
            String message = Translator.translateToLocal("jei.tooltip.error.recipe.transfer.missing");
            return handlerHelper.createUserErrorWithTooltip(message);
        }
        ArrayList<Integer> craftingSlotIndexes = new ArrayList<Integer>(craftingSlots.keySet());
        Collections.sort(craftingSlotIndexes);
        ArrayList<Integer> inventorySlotIndexes = new ArrayList<Integer>(inventorySlots.keySet());
        Collections.sort(inventorySlotIndexes);
        for (Map.Entry<Integer, ItemStack> entry : slotMap.entrySet()) {
            int craftNumber = entry.getKey();
            int slotNumber = (Integer)craftingSlotIndexes.get(craftNumber);
            if (slotNumber >= container.field_75151_b.size()) {
                Log.error("Recipes Transfer Helper {} references slot {} outside of the inventory's size {}", this.transferHelper.getClass(), slotNumber, container.field_75151_b.size());
                return handlerHelper.createInternalError();
            }
            Slot slot = container.func_75139_a(slotNumber);
            ItemStack stack = entry.getValue();
            if (slot == null) {
                Log.error("The slot number {} does not exist in the container.", slotNumber);
                return handlerHelper.createInternalError();
            }
            if (slot.func_75214_a(stack)) continue;
            Log.error("The ItemStack {} is not valid for the slot number {}", stack, slotNumber);
            return handlerHelper.createInternalError();
        }
        if (doTransfer) {
            PacketRecipeTransfer packet = new PacketRecipeTransfer(slotMap, craftingSlotIndexes, inventorySlotIndexes);
            JustEnoughItems.getProxy().sendPacketToServer(packet);
        }
        return null;
    }

    @Nullable
    private static Map<Integer, ItemStack> buildSlotMap(@Nonnull GuiItemStackGroup itemStackGroup, @Nonnull List<ItemStack> matchingStacks) {
        HashMap<Integer, ItemStack> slotMap = new HashMap<Integer, ItemStack>();
        Map ingredientsMap = itemStackGroup.getGuiIngredients();
        int recipeSlotNumber = -1;
        TreeSet<Integer> keys = new TreeSet<Integer>(ingredientsMap.keySet());
        for (Integer key : keys) {
            GuiIngredient guiIngredient = (GuiIngredient)ingredientsMap.get(key);
            if (!guiIngredient.isInput()) continue;
            ++recipeSlotNumber;
            List<ItemStack> requiredStacks = guiIngredient.getAll();
            if (requiredStacks.isEmpty()) continue;
            ItemStack matchingStack = StackUtil.containsStack(matchingStacks, requiredStacks);
            if (matchingStack != null) {
                slotMap.put(recipeSlotNumber, matchingStack);
                matchingStacks.remove(matchingStack);
                continue;
            }
            return null;
        }
        return slotMap;
    }

    public static void setItems(@Nonnull EntityPlayer player, @Nonnull Map<Integer, ItemStack> slotMap, @Nonnull List<Integer> craftingSlots, @Nonnull List<Integer> inventorySlots) {
        Container container = player.field_71070_bA;
        ArrayList<ItemStack> removeRecipeItems = new ArrayList<ItemStack>();
        for (ItemStack matchingStack : slotMap.values()) {
            ItemStack itemStack = matchingStack.func_77946_l();
            while (itemStack.field_77994_a > 0) {
                Slot inventorySlot = BasicRecipeTransferHandler.getSlotWithStack(container, craftingSlots, itemStack);
                if (inventorySlot == null && (inventorySlot = BasicRecipeTransferHandler.getSlotWithStack(container, inventorySlots, itemStack)) == null) {
                    Log.error("Couldn't find required items in inventory, even though they should be there.", new Object[0]);
                    ArrayList<Integer> allSlots = new ArrayList<Integer>();
                    allSlots.addAll(inventorySlots);
                    allSlots.addAll(craftingSlots);
                    for (ItemStack removedRecipeItem : removeRecipeItems) {
                        StackUtil.addStack(container, allSlots, removedRecipeItem, true);
                    }
                    return;
                }
                ItemStack removed = inventorySlot.func_75209_a(itemStack.field_77994_a);
                removeRecipeItems.add(removed);
                itemStack.field_77994_a -= removed.field_77994_a;
            }
        }
        ArrayList<ItemStack> clearedCraftingItems = new ArrayList<ItemStack>();
        for (Integer n : craftingSlots) {
            Slot craftingSlot = container.func_75139_a(n.intValue());
            if (craftingSlot == null || !craftingSlot.func_75216_d()) continue;
            ItemStack craftingItem = craftingSlot.func_75209_a(Integer.MAX_VALUE);
            clearedCraftingItems.add(craftingItem);
        }
        for (Map.Entry entry : slotMap.entrySet()) {
            ItemStack stack = (ItemStack)entry.getValue();
            Integer craftNumber = (Integer)entry.getKey();
            Integer slotNumber = craftingSlots.get(craftNumber);
            Slot slot = container.func_75139_a(slotNumber.intValue());
            slot.func_75215_d(stack);
        }
        for (ItemStack itemStack : clearedCraftingItems) {
            StackUtil.addStack(container, inventorySlots, itemStack, true);
        }
        container.func_75142_b();
    }

    private static List<List<ItemStack>> getInputStacks(@Nonnull Map<Integer, GuiIngredient<ItemStack>> guiItemStacks) {
        ArrayList<List<ItemStack>> inputStacks = new ArrayList<List<ItemStack>>();
        for (Map.Entry<Integer, GuiIngredient<ItemStack>> entry : guiItemStacks.entrySet()) {
            if (!entry.getValue().isInput()) continue;
            inputStacks.add(entry.getValue().getAll());
        }
        return inputStacks;
    }

    @Nonnull
    private static MatchingItemsResult getMatchingItems(@Nonnull List<ItemStack> availableItemStacks, @Nonnull List<List<ItemStack>> requiredStacksList) {
        MatchingItemsResult matchingItemResult = new MatchingItemsResult();
        for (List<ItemStack> requiredStacks : requiredStacksList) {
            if (requiredStacks.isEmpty()) continue;
            ItemStack matching = null;
            for (ItemStack requiredStack : requiredStacks) {
                if (StackUtil.containsStack(availableItemStacks, requiredStack) == null) continue;
                matching = requiredStack.func_77946_l();
                break;
            }
            if (matching == null) {
                matchingItemResult.missingItems.add(requiredStacks);
                continue;
            }
            matchingItemResult.matchingItems.add(matching);
        }
        return matchingItemResult;
    }

    @Nullable
    private static Slot getSlotWithStack(@Nonnull Container container, @Nonnull Iterable<Integer> slotNumbers, @Nonnull ItemStack stack) {
        for (Integer slotNumber : slotNumbers) {
            ItemStack slotStack;
            Slot slot = container.func_75139_a(slotNumber.intValue());
            if (slot == null || !StackUtil.isIdentical(stack, slotStack = slot.func_75211_c())) continue;
            return slot;
        }
        return null;
    }

    public static class MatchingItemsResult {
        @Nonnull
        public final List<ItemStack> matchingItems = new ArrayList<ItemStack>();
        @Nonnull
        public final List<List<ItemStack>> missingItems = new ArrayList<List<ItemStack>>();
    }
}

