/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.brewing;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mezz.jei.api.IItemRegistry;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeWrapper;
import mezz.jei.util.Log;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.brewing.BrewingOreRecipe;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;

public class BrewingRecipeMaker {
    private static final Set<Class> unhandledRecipeClasses = new HashSet<Class>();

    @Nonnull
    public static List<BrewingRecipeWrapper> getBrewingRecipes(IItemRegistry itemRegistry) {
        HashSet<BrewingRecipeWrapper> recipes = new HashSet<BrewingRecipeWrapper>();
        BrewingRecipeMaker.addVanillaBrewingRecipes(itemRegistry, recipes);
        BrewingRecipeMaker.addModdedBrewingRecipes(recipes);
        ArrayList<BrewingRecipeWrapper> recipeList = new ArrayList<BrewingRecipeWrapper>(recipes);
        Collections.sort(recipeList, new Comparator<BrewingRecipeWrapper>(){

            @Override
            public int compare(BrewingRecipeWrapper o1, BrewingRecipeWrapper o2) {
                return Integer.compare(o1.getBrewingSteps(), o2.getBrewingSteps());
            }
        });
        return recipeList;
    }

    private static void addVanillaBrewingRecipes(IItemRegistry itemRegistry, Collection<BrewingRecipeWrapper> recipes) {
        ImmutableList<ItemStack> potionIngredients = itemRegistry.getPotionIngredients();
        VanillaBrewingRecipe vanillaBrewingRecipe = new VanillaBrewingRecipe();
        HashSet<Integer> potionMetas = new HashSet<Integer>();
        potionMetas.add(0);
        int brewingSteps = 1;
        ItemStack potionInput = new ItemStack((Item)Items.field_151068_bn);
        HashSet<Integer> newPotionMetas = new HashSet<Integer>();
        do {
            newPotionMetas.clear();
            for (Integer potionInputMeta : potionMetas) {
                potionInput.func_77964_b(potionInputMeta.intValue());
                for (ItemStack potionIngredient : potionIngredients) {
                    BrewingRecipeWrapper recipe;
                    ItemStack potionOutput = vanillaBrewingRecipe.getOutput(potionInput, potionIngredient);
                    if (potionOutput == null) continue;
                    int potionOutputMeta = potionOutput.func_77960_j();
                    if (potionInputMeta == potionOutputMeta || recipes.contains(recipe = new BrewingRecipeWrapper(potionIngredient, potionInput.func_77946_l(), potionOutput, brewingSteps))) continue;
                    recipes.add(recipe);
                    newPotionMetas.add(potionOutputMeta);
                }
            }
            potionMetas.addAll(newPotionMetas);
            if (++brewingSteps <= 100) continue;
            Log.error("Calculation of vanilla brewing recipes is broken, aborting after 100 brewing steps.", new Object[0]);
            return;
        } while (newPotionMetas.size() > 0);
    }

    private static void addModdedBrewingRecipes(Collection<BrewingRecipeWrapper> recipes) {
        List brewingRecipes = BrewingRecipeRegistry.getRecipes();
        for (IBrewingRecipe iBrewingRecipe : brewingRecipes) {
            Class<?> recipeClass;
            BrewingRecipeWrapper recipe;
            BrewingRecipe brewingRecipe;
            if (iBrewingRecipe instanceof BrewingRecipe) {
                brewingRecipe = (BrewingRecipe)iBrewingRecipe;
                recipe = new BrewingRecipeWrapper((ItemStack)brewingRecipe.ingredient, brewingRecipe.input, brewingRecipe.output, 0);
                recipes.add(recipe);
                continue;
            }
            if (iBrewingRecipe instanceof BrewingOreRecipe) {
                brewingRecipe = (BrewingOreRecipe)iBrewingRecipe;
                recipe = new BrewingRecipeWrapper((List)brewingRecipe.ingredient, brewingRecipe.input, brewingRecipe.output, 0);
                recipes.add(recipe);
                continue;
            }
            if (iBrewingRecipe instanceof VanillaBrewingRecipe || unhandledRecipeClasses.contains(recipeClass = iBrewingRecipe.getClass())) continue;
            unhandledRecipeClasses.add(recipeClass);
            Log.debug("Can't handle brewing recipe class: {}", recipeClass);
        }
    }
}

