/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IItemRegistry;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeCategory;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeHandler;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeMaker;
import mezz.jei.plugins.vanilla.crafting.CraftingRecipeCategory;
import mezz.jei.plugins.vanilla.crafting.CraftingRecipeMaker;
import mezz.jei.plugins.vanilla.crafting.ShapedOreRecipeHandler;
import mezz.jei.plugins.vanilla.crafting.ShapedRecipesHandler;
import mezz.jei.plugins.vanilla.crafting.ShapelessOreRecipeHandler;
import mezz.jei.plugins.vanilla.crafting.ShapelessRecipesHandler;
import mezz.jei.plugins.vanilla.furnace.FuelRecipeHandler;
import mezz.jei.plugins.vanilla.furnace.FuelRecipeMaker;
import mezz.jei.plugins.vanilla.furnace.FurnaceFuelCategory;
import mezz.jei.plugins.vanilla.furnace.FurnaceSmeltingCategory;
import mezz.jei.plugins.vanilla.furnace.SmeltingRecipeHandler;
import mezz.jei.plugins.vanilla.furnace.SmeltingRecipeMaker;
import net.minecraft.inventory.ContainerBrewingStand;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.ContainerWorkbench;

@JEIPlugin
public class VanillaPlugin
implements IModPlugin {
    private IItemRegistry itemRegistry;
    private IJeiHelpers jeiHelpers;

    @Override
    public boolean isModLoaded() {
        return true;
    }

    @Override
    public void onJeiHelpersAvailable(IJeiHelpers jeiHelpers) {
        this.jeiHelpers = jeiHelpers;
    }

    @Override
    public void onItemRegistryAvailable(IItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    @Override
    public void register(IModRegistry registry) {
        IGuiHelper guiHelper = this.jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new CraftingRecipeCategory(guiHelper), new FurnaceFuelCategory(guiHelper), new FurnaceSmeltingCategory(guiHelper), new BrewingRecipeCategory(guiHelper));
        registry.addRecipeHandlers(new ShapedOreRecipeHandler(), new ShapedRecipesHandler(), new ShapelessOreRecipeHandler(), new ShapelessRecipesHandler(), new FuelRecipeHandler(), new SmeltingRecipeHandler(), new BrewingRecipeHandler());
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler(ContainerWorkbench.class, "minecraft.crafting", 1, 9, 10, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerFurnace.class, "minecraft.smelting", 0, 1, 1, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerFurnace.class, "minecraft.fuel", 1, 1, 1, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerBrewingStand.class, "minecraft.brewing", 0, 4, 4, 36);
        registry.addRecipes(CraftingRecipeMaker.getCraftingRecipes());
        registry.addRecipes(SmeltingRecipeMaker.getFurnaceRecipes());
        registry.addRecipes(FuelRecipeMaker.getFuelRecipes(this.itemRegistry, guiHelper));
        registry.addRecipes(BrewingRecipeMaker.getBrewingRecipes(this.itemRegistry));
    }

    @Override
    public void onRecipeRegistryAvailable(IRecipeRegistry recipeRegistry) {
    }
}

