/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network;

import java.io.IOException;
import mezz.jei.network.PacketIdServer;
import mezz.jei.network.packets.PacketDeletePlayerItem;
import mezz.jei.network.packets.PacketGiveItemMessageBig;
import mezz.jei.network.packets.PacketJEI;
import mezz.jei.network.packets.PacketRecipeTransfer;
import mezz.jei.util.Log;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class PacketHandler {
    public static final String CHANNEL_ID = "JEI";
    private final FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("JEI");

    public PacketHandler() {
        this.channel.register((Object)this);
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        PacketBuffer packetBuffer = new PacketBuffer(event.packet.payload());
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        try {
            PacketJEI packet;
            byte packetIdOrdinal = packetBuffer.readByte();
            PacketIdServer packetId = PacketIdServer.VALUES[packetIdOrdinal];
            switch (packetId) {
                case RECIPE_TRANSFER: {
                    packet = new PacketRecipeTransfer();
                    break;
                }
                case DELETE_ITEM: {
                    packet = new PacketDeletePlayerItem();
                    break;
                }
                case GIVE_BIG: {
                    packet = new PacketGiveItemMessageBig();
                    break;
                }
                default: {
                    return;
                }
            }
            PacketHandler.checkThreadAndEnqueue(packet, packetBuffer, (EntityPlayer)player, (IThreadListener)player.func_71121_q());
        }
        catch (Exception ex) {
            Log.error("Packet error", ex);
        }
    }

    public void sendPacket(FMLProxyPacket packet, EntityPlayerMP player) {
        this.channel.sendTo(packet, player);
    }

    private static void checkThreadAndEnqueue(final PacketJEI packet, final PacketBuffer packetBuffer, final EntityPlayer player, IThreadListener threadListener) {
        if (!threadListener.func_152345_ab()) {
            threadListener.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    try {
                        packet.readPacketData(packetBuffer, player);
                    }
                    catch (IOException e) {
                        Log.error("Network Error", e);
                    }
                }
            });
        }
    }
}

