/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.config.Config;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.Focus;
import mezz.jei.gui.ItemListOverlay;
import mezz.jei.gui.RecipesGui;
import mezz.jei.input.GuiContainerWrapper;
import mezz.jei.input.IKeyable;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.util.Commands;
import mezz.jei.util.MouseHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class InputHandler {
    private final RecipesGui recipesGui;
    private final ItemListOverlay itemListOverlay;
    private final MouseHelper mouseHelper;
    private final List<IMouseHandler> mouseHandlers = new ArrayList<IMouseHandler>();
    private final List<IKeyable> keyables = new ArrayList<IKeyable>();
    private final List<IShowsRecipeFocuses> showsRecipeFocuses = new ArrayList<IShowsRecipeFocuses>();
    private boolean clickHandled = false;

    public InputHandler(RecipesGui recipesGui, ItemListOverlay itemListOverlay, GuiContainer guiContainer) {
        this.recipesGui = recipesGui;
        this.itemListOverlay = itemListOverlay;
        this.mouseHelper = new MouseHelper();
        ArrayList<IShowsRecipeFocuses> objects = new ArrayList<IShowsRecipeFocuses>();
        objects.add(recipesGui);
        objects.add(itemListOverlay);
        objects.add(new GuiContainerWrapper(guiContainer, recipesGui));
        for (Object e : objects) {
            if (e instanceof IMouseHandler) {
                this.mouseHandlers.add((IMouseHandler)e);
            }
            if (e instanceof IKeyable) {
                this.keyables.add((IKeyable)e);
            }
            if (!(e instanceof IShowsRecipeFocuses)) continue;
            this.showsRecipeFocuses.add((IShowsRecipeFocuses)e);
        }
    }

    public boolean handleMouseEvent(int mouseX, int mouseY) {
        boolean cancelEvent = false;
        if (Mouse.getEventButton() > -1) {
            if (Mouse.getEventButtonState()) {
                if (!this.clickHandled) {
                    this.clickHandled = cancelEvent = this.handleMouseClick(Mouse.getEventButton(), mouseX, mouseY);
                }
            } else if (this.clickHandled) {
                this.clickHandled = false;
                cancelEvent = true;
            }
        } else if (Mouse.getEventDWheel() != 0) {
            cancelEvent = this.handleMouseScroll(Mouse.getEventDWheel(), mouseX, mouseY);
        }
        return cancelEvent;
    }

    private boolean handleMouseScroll(int dWheel, int mouseX, int mouseY) {
        for (IMouseHandler scrollable : this.mouseHandlers) {
            if (!scrollable.handleMouseScrolled(mouseX, mouseY, dWheel)) continue;
            return true;
        }
        return false;
    }

    private boolean handleMouseClick(int mouseButton, int mouseX, int mouseY) {
        for (IMouseHandler clickable : this.mouseHandlers) {
            if (!clickable.handleMouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        Focus focus = this.getFocusUnderMouseForClick(mouseX, mouseY);
        if (focus != null && this.handleMouseClickedFocus(mouseButton, focus)) {
            return true;
        }
        return this.recipesGui.isOpen();
    }

    @Nullable
    private Focus getFocusUnderMouseForClick(int mouseX, int mouseY) {
        for (IShowsRecipeFocuses gui : this.showsRecipeFocuses) {
            Focus focus;
            if (!(gui instanceof IMouseHandler) || (focus = gui.getFocusUnderMouse(mouseX, mouseY)) == null) continue;
            return focus;
        }
        return null;
    }

    @Nullable
    private Focus getFocusUnderMouseForKey(int mouseX, int mouseY) {
        for (IShowsRecipeFocuses gui : this.showsRecipeFocuses) {
            Focus focus = gui.getFocusUnderMouse(mouseX, mouseY);
            if (focus == null) continue;
            return focus;
        }
        return null;
    }

    private boolean handleMouseClickedFocus(int mouseButton, @Nonnull Focus focus) {
        if (Config.isEditModeEnabled() && GuiScreen.func_146271_m() && this.handleClickEditStack(mouseButton, focus)) {
            return true;
        }
        if (Config.isCheatItemsEnabled() && focus.getStack() != null) {
            if (mouseButton == 0) {
                Commands.giveFullStack(focus.getStack());
                return true;
            }
            if (mouseButton == 1) {
                Commands.giveOneFromStack(focus.getStack());
                return true;
            }
        }
        if (mouseButton == 0) {
            this.recipesGui.showRecipes(focus);
            return true;
        }
        if (mouseButton == 1) {
            this.recipesGui.showUses(focus);
            return true;
        }
        return false;
    }

    private boolean handleClickEditStack(int mouseButton, @Nonnull Focus focus) {
        boolean wildcard;
        ItemStack itemStack = focus.getStack();
        if (itemStack == null) {
            return false;
        }
        if (mouseButton == 0) {
            wildcard = false;
        } else if (mouseButton == 1) {
            wildcard = true;
        } else {
            return false;
        }
        if (Config.isItemOnConfigBlacklist(focus.getStack(), wildcard)) {
            Config.removeItemFromConfigBlacklist(focus.getStack(), wildcard);
        } else {
            Config.addItemToConfigBlacklist(focus.getStack(), wildcard);
        }
        return true;
    }

    public boolean handleKeyEvent() {
        boolean cancelEvent = false;
        if (Keyboard.getEventKeyState()) {
            int eventKey = Keyboard.getEventKey();
            cancelEvent = this.handleKeyDown(eventKey);
        }
        return cancelEvent;
    }

    private boolean handleKeyDown(int eventKey) {
        Focus focus;
        for (IKeyable keyable : this.keyables) {
            if (!keyable.isOpen() || !keyable.hasKeyboardFocus()) continue;
            if (this.isInventoryCloseKey(eventKey)) {
                keyable.setKeyboardFocus(false);
                return true;
            }
            if (!keyable.onKeyPressed(eventKey)) continue;
            return true;
        }
        if ((this.isInventoryCloseKey(eventKey) || this.isInventoryToggleKey(eventKey)) && this.recipesGui.isOpen()) {
            this.recipesGui.close();
            return true;
        }
        if (eventKey == KeyBindings.showRecipe.func_151463_i()) {
            focus = this.getFocusUnderMouseForKey(this.mouseHelper.getX(), this.mouseHelper.getY());
            if (focus != null) {
                this.recipesGui.showRecipes(focus);
                return true;
            }
        } else if (eventKey == KeyBindings.showUses.func_151463_i()) {
            focus = this.getFocusUnderMouseForKey(this.mouseHelper.getX(), this.mouseHelper.getY());
            if (focus != null) {
                this.recipesGui.showUses(focus);
                return true;
            }
        } else {
            if (eventKey == KeyBindings.toggleOverlay.func_151463_i() && GuiScreen.func_146271_m()) {
                this.itemListOverlay.toggleEnabled();
                return false;
            }
            if (eventKey == 33 && GuiScreen.func_146271_m()) {
                this.itemListOverlay.setKeyboardFocus(true);
                return true;
            }
            if (eventKey == 14 && this.recipesGui.isOpen()) {
                this.recipesGui.back();
                return true;
            }
        }
        for (IKeyable keyable : this.keyables) {
            if (!keyable.isOpen() || !keyable.onKeyPressed(eventKey)) continue;
            return true;
        }
        return false;
    }

    private boolean isInventoryToggleKey(int keyCode) {
        return keyCode == Minecraft.func_71410_x().field_71474_y.field_151445_Q.func_151463_i();
    }

    private boolean isInventoryCloseKey(int keyCode) {
        return keyCode == 1;
    }
}

