/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.ItemFilter;
import mezz.jei.util.ItemStackElement;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.client.config.HoverChecker;
import org.lwjgl.input.Keyboard;

public class GuiTextFieldFilter
extends GuiTextField {
    private static final int MAX_HISTORY = 100;
    private static final int maxSearchLength = 32;
    private final List<String> history = new LinkedList<String>();
    private final HoverChecker hoverChecker;
    private ItemFilter itemFilter;

    public GuiTextFieldFilter(int componentId, FontRenderer fontRenderer, int x, int y, int width, int height) {
        super(componentId, fontRenderer, x, y, width, height);
        this.func_146203_f(32);
        this.hoverChecker = new HoverChecker(y, y + height, x, x + width, 0);
    }

    public void setItemFilter(ItemFilter itemFilter) {
        this.itemFilter = itemFilter;
        this.func_146180_a(itemFilter.getFilterText());
    }

    public void update() {
        ImmutableList<ItemStackElement> itemList = this.itemFilter.getItemList();
        if (itemList.size() == 0) {
            this.func_146193_g(Color.red.getRGB());
            this.func_146203_f(this.func_146179_b().length());
        } else {
            this.func_146193_g(Color.white.getRGB());
            this.func_146203_f(32);
        }
    }

    public boolean func_146201_a(char character, int keyCode) {
        boolean handled = super.func_146201_a(character, keyCode);
        if (!handled && !this.history.isEmpty()) {
            if (keyCode == 200) {
                String currentText = this.func_146179_b();
                int historyIndex = this.history.indexOf(currentText);
                if (historyIndex < 0) {
                    historyIndex = this.saveHistory() ? this.history.size() - 1 : this.history.size();
                }
                if (historyIndex > 0) {
                    String historyString = this.history.get(historyIndex - 1);
                    this.func_146180_a(historyString);
                    handled = true;
                }
            } else if (keyCode == 208) {
                String currentText = this.func_146179_b();
                int historyIndex = this.history.indexOf(currentText);
                if (historyIndex >= 0) {
                    String historyString = historyIndex + 1 < this.history.size() ? this.history.get(historyIndex + 1) : "";
                    this.func_146180_a(historyString);
                    handled = true;
                }
            } else if (keyCode == 28) {
                this.saveHistory();
            }
        }
        return handled && ItemFilter.setFilterText(this.func_146179_b());
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.hoverChecker.checkHover(mouseX, mouseY);
    }

    public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 1) {
            this.func_146180_a("");
            return ItemFilter.setFilterText("");
        }
        super.func_146192_a(mouseX, mouseY, mouseButton);
        return false;
    }

    public void func_146195_b(boolean keyboardFocus) {
        super.func_146195_b(keyboardFocus);
        Keyboard.enableRepeatEvents((boolean)keyboardFocus);
        if (!keyboardFocus) {
            this.saveHistory();
        }
    }

    private boolean saveHistory() {
        String text = this.func_146179_b();
        if (text.length() > 0) {
            this.history.remove(text);
            this.history.add(text);
            if (this.history.size() > 100) {
                this.history.remove(0);
            }
            return true;
        }
        return false;
    }
}

