/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.gui.Focus;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.IGuiIngredient;
import mezz.jei.gui.ingredients.IIngredientHelper;
import mezz.jei.gui.ingredients.IIngredientRenderer;
import mezz.jei.util.CycleTimer;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;

public class GuiIngredient<T>
extends Gui
implements IGuiIngredient<T> {
    private final boolean input;
    private final int xPosition;
    private final int yPosition;
    private final int width;
    private final int height;
    private final int padding;
    @Nonnull
    private final CycleTimer cycleTimer = new CycleTimer();
    @Nonnull
    private final List<T> contained = new ArrayList<T>();
    @Nonnull
    private final IIngredientRenderer<T> ingredientRenderer;
    @Nonnull
    private final IIngredientHelper<T> ingredientHelper;
    private boolean enabled;

    public GuiIngredient(@Nonnull IIngredientRenderer<T> ingredientRenderer, @Nonnull IIngredientHelper<T> ingredientHelper, boolean input, int xPosition, int yPosition, int width, int height, int padding) {
        this.ingredientRenderer = ingredientRenderer;
        this.ingredientHelper = ingredientHelper;
        this.input = input;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.padding = padding;
    }

    @Override
    public void clear() {
        this.enabled = false;
        this.contained.clear();
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.enabled && mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    @Override
    @Nullable
    public T get() {
        return this.cycleTimer.getCycledItem(this.contained);
    }

    @Override
    @Nonnull
    public List<T> getAll() {
        return this.contained;
    }

    @Override
    public void set(@Nonnull T contained, @Nonnull Focus focus) {
        this.set((Collection<T>)Collections.singleton(contained), focus);
    }

    @Override
    public void set(@Nonnull Collection<T> contained, @Nonnull Focus focus) {
        this.contained.clear();
        contained = this.ingredientHelper.expandSubtypes(contained);
        Object match = null;
        if (this.isInput() && focus.getMode() == Focus.Mode.INPUT || !this.isInput() && focus.getMode() == Focus.Mode.OUTPUT) {
            match = this.ingredientHelper.getMatch(contained, focus);
        }
        if (match != null) {
            this.contained.add(match);
        } else {
            this.contained.addAll(contained);
        }
        this.enabled = !this.contained.isEmpty();
    }

    @Override
    public void draw(@Nonnull Minecraft minecraft) {
        this.draw(minecraft, true);
    }

    @Override
    public void drawHovered(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
        T value = this.get();
        if (value == null) {
            return;
        }
        this.draw(minecraft, false);
        this.drawTooltip(minecraft, mouseX, mouseY, value);
    }

    @Override
    public void drawHighlight(@Nonnull Minecraft minecraft, Color color, int xOffset, int yOffset) {
        int x = this.xPosition + xOffset;
        int y = this.yPosition + yOffset;
        GuiScreen.func_73734_a((int)x, (int)y, (int)(x + this.width), (int)(y + this.height), (int)color.getRGB());
    }

    private void draw(Minecraft minecraft, boolean cycleIcons) {
        this.cycleTimer.onDraw(cycleIcons);
        T value = this.get();
        this.ingredientRenderer.draw(minecraft, this.xPosition + this.padding, this.yPosition + this.padding, value);
    }

    private void drawTooltip(@Nonnull Minecraft minecraft, int mouseX, int mouseY, @Nonnull T value) {
        try {
            GlStateManager.func_179097_i();
            RenderHelper.func_74518_a();
            GuiIngredient.func_73734_a((int)this.xPosition, (int)this.yPosition, (int)(this.xPosition + this.width), (int)(this.yPosition + this.height), (int)Integer.MAX_VALUE);
            List<String> tooltip = this.ingredientRenderer.getTooltip(minecraft, value);
            FontRenderer fontRenderer = this.ingredientRenderer.getFontRenderer(minecraft, value);
            TooltipRenderer.drawHoveringText(minecraft, tooltip, mouseX, mouseY, fontRenderer);
            GlStateManager.func_179126_j();
        }
        catch (RuntimeException e) {
            Log.error("Exception when rendering tooltip on {}.", value, e);
        }
    }

    public boolean isInput() {
        return this.input;
    }
}

