/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.config.Constants;
import mezz.jei.gui.Focus;
import mezz.jei.gui.IRecipeGuiLogic;
import mezz.jei.gui.RecipeGuiLogic;
import mezz.jei.gui.RecipeLayout;
import mezz.jei.gui.RecipeTransferButton;
import mezz.jei.gui.RecipesGuiInitEvent;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.transfer.RecipeTransferUtil;
import mezz.jei.util.Log;
import mezz.jei.util.StringUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.common.eventhandler.Event;

public class RecipesGui
extends GuiScreen
implements IShowsRecipeFocuses,
IMouseHandler {
    private static final int borderPadding = 8;
    private static final int textPadding = 5;
    private int titleHeight;
    private int headerHeight;
    private int buttonWidth;
    private final IRecipeGuiLogic logic = new RecipeGuiLogic();
    @Nonnull
    private final List<RecipeLayout> recipeLayouts = new ArrayList<RecipeLayout>();
    private String pageString;
    private String title;
    private ResourceLocation backgroundTexture;
    private HoverChecker titleHoverChecker;
    private GuiButton nextRecipeCategory;
    private GuiButton previousRecipeCategory;
    private GuiButton nextPage;
    private GuiButton previousPage;
    private boolean isOpen = false;
    private int guiLeft;
    private int guiTop;
    private int xSize;
    private int ySize;
    private boolean guiActionPerformed = false;

    public void initGui(@Nonnull Minecraft minecraft) {
        this.func_146280_a(minecraft, minecraft.field_71462_r.field_146294_l, minecraft.field_71462_r.field_146295_m);
        this.xSize = 176;
        if (this.field_146295_m > 300) {
            this.ySize = 256;
            this.backgroundTexture = new ResourceLocation(Constants.RESOURCE_DOMAIN, "textures/gui/recipeBackgroundTall.png");
        } else {
            this.ySize = 166;
            this.backgroundTexture = new ResourceLocation(Constants.RESOURCE_DOMAIN, "textures/gui/recipeBackground.png");
        }
        this.guiLeft = (minecraft.field_71462_r.field_146294_l - this.xSize) / 2;
        this.guiTop = (minecraft.field_71462_r.field_146295_m - this.ySize) / 2;
        this.titleHeight = this.field_146289_q.field_78288_b + 8;
        this.headerHeight = this.titleHeight + this.field_146289_q.field_78288_b + 5;
        this.buttonWidth = 13;
        int buttonHeight = this.field_146289_q.field_78288_b + 3;
        int rightButtonX = this.guiLeft + this.xSize - 8 - this.buttonWidth;
        int leftButtonX = this.guiLeft + 8;
        int recipeClassButtonTop = this.guiTop + 8 - 2;
        this.nextRecipeCategory = new GuiButtonExt(2, rightButtonX, recipeClassButtonTop, this.buttonWidth, buttonHeight, ">");
        this.previousRecipeCategory = new GuiButtonExt(3, leftButtonX, recipeClassButtonTop, this.buttonWidth, buttonHeight, "<");
        int pageButtonTop = this.guiTop + this.titleHeight + 3;
        this.nextPage = new GuiButtonExt(4, rightButtonX, pageButtonTop, this.buttonWidth, buttonHeight, ">");
        this.previousPage = new GuiButtonExt(5, leftButtonX, pageButtonTop, this.buttonWidth, buttonHeight, "<");
        this.addButtons();
        this.updateLayout();
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        this.field_146297_k = mc;
        this.field_146296_j = mc.func_175599_af();
        this.field_146289_q = mc.field_71466_p;
        this.field_146294_l = width;
        this.field_146295_m = height;
        MinecraftForge.EVENT_BUS.post((Event)new RecipesGuiInitEvent());
        this.field_146292_n.clear();
        this.func_73866_w_();
    }

    private void addButtons() {
        this.field_146292_n.add(this.nextRecipeCategory);
        this.field_146292_n.add(this.previousRecipeCategory);
        this.field_146292_n.add(this.nextPage);
        this.field_146292_n.add(this.previousPage);
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.isOpen() && mouseX >= this.guiLeft && mouseY >= this.guiTop && mouseX < this.guiLeft + this.xSize && mouseY < this.guiTop + this.ySize;
    }

    @Override
    @Nullable
    public Focus getFocusUnderMouse(int mouseX, int mouseY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return null;
        }
        for (RecipeLayout recipeLayouts : this.recipeLayouts) {
            Focus focus = recipeLayouts.getFocusUnderMouse(mouseX, mouseY);
            if (focus == null) continue;
            return focus;
        }
        return null;
    }

    @Override
    public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        this.guiActionPerformed = false;
        try {
            this.func_146274_d();
        }
        catch (IOException e) {
            Log.error("IOException on mouse click.", e);
        }
        if (!this.guiActionPerformed && this.titleHoverChecker.checkHover(mouseX, mouseY)) {
            boolean success = this.logic.setCategoryFocus();
            if (success) {
                this.updateLayout();
            }
            return success;
        }
        return this.guiActionPerformed;
    }

    @Override
    public boolean handleMouseScrolled(int mouseX, int mouseY, int scrollDelta) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (scrollDelta < 0) {
            this.logic.nextPage();
            this.updateLayout();
            return true;
        }
        if (scrollDelta > 0) {
            this.logic.previousPage();
            this.updateLayout();
            return true;
        }
        return false;
    }

    @Override
    public void open() {
        this.isOpen = true;
    }

    @Override
    public void close() {
        this.isOpen = false;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen && this.logic.getRecipeCategory() != null;
    }

    public void showRecipes(@Nonnull Focus focus) {
        focus.setMode(Focus.Mode.OUTPUT);
        if (this.logic.setFocus(focus)) {
            this.updateLayout();
            this.open();
        }
    }

    public void showUses(@Nonnull Focus focus) {
        focus.setMode(Focus.Mode.INPUT);
        if (this.logic.setFocus(focus)) {
            this.updateLayout();
            this.open();
        }
    }

    public void back() {
        if (this.logic.back()) {
            this.updateLayout();
        }
    }

    protected void func_146284_a(@Nonnull GuiButton guibutton) {
        boolean updateLayout = true;
        if (guibutton.field_146127_k == this.nextPage.field_146127_k) {
            this.logic.nextPage();
        } else if (guibutton.field_146127_k == this.previousPage.field_146127_k) {
            this.logic.previousPage();
        } else if (guibutton.field_146127_k == this.nextRecipeCategory.field_146127_k) {
            this.logic.nextRecipeCategory();
        } else if (guibutton.field_146127_k == this.previousRecipeCategory.field_146127_k) {
            this.logic.previousRecipeCategory();
        } else if (guibutton.field_146127_k >= 100) {
            int recipeIndex = guibutton.field_146127_k - 100;
            RecipeLayout recipeLayout = this.recipeLayouts.get(recipeIndex);
            if (RecipeTransferUtil.transferRecipe(recipeLayout, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                this.close();
                this.guiActionPerformed = true;
                updateLayout = false;
            }
        } else {
            updateLayout = false;
        }
        if (updateLayout) {
            this.updateLayout();
            this.guiActionPerformed = true;
        }
    }

    private void updateLayout() {
        IRecipeCategory recipeCategory = this.logic.getRecipeCategory();
        if (recipeCategory == null) {
            return;
        }
        IDrawable recipeBackground = recipeCategory.getBackground();
        int recipesPerPage = Math.max(1, (this.ySize - this.headerHeight) / (recipeBackground.getHeight() + 8));
        int recipeXOffset = (this.xSize - recipeBackground.getWidth()) / 2;
        int recipeSpacing = (this.ySize - this.headerHeight - recipesPerPage * recipeBackground.getHeight()) / (recipesPerPage + 1);
        this.logic.setRecipesPerPage(recipesPerPage);
        this.title = recipeCategory.getTitle();
        int titleWidth = this.field_146289_q.func_78256_a(this.title);
        int titleX = this.guiLeft + (this.xSize - titleWidth) / 2;
        int titleY = this.guiTop + 8;
        this.titleHoverChecker = new HoverChecker(titleY, titleY + this.field_146289_q.field_78288_b, titleX, titleX + titleWidth, 0);
        int posX = this.guiLeft + recipeXOffset;
        int posY = this.guiTop + this.headerHeight + recipeSpacing;
        int spacingY = recipeBackground.getHeight() + recipeSpacing;
        this.recipeLayouts.clear();
        this.recipeLayouts.addAll(this.logic.getRecipeWidgets(posX, posY, spacingY));
        this.addRecipeTransferButtons(this.recipeLayouts);
        this.nextPage.field_146124_l = this.previousPage.field_146124_l = this.logic.hasMultiplePages();
        this.nextRecipeCategory.field_146124_l = this.previousRecipeCategory.field_146124_l = this.logic.hasMultipleCategories();
        this.pageString = this.logic.getPageString();
    }

    private void addRecipeTransferButtons(List<RecipeLayout> recipeLayouts) {
        this.field_146292_n.clear();
        this.addButtons();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        for (RecipeLayout recipeLayout : recipeLayouts) {
            RecipeTransferButton button = recipeLayout.getRecipeTransferButton();
            button.init(recipeLayout, (EntityPlayer)player);
            this.field_146292_n.add(button);
        }
    }

    public void draw(int mouseX, int mouseY) {
        Focus focus;
        Minecraft minecraft = Minecraft.func_71410_x();
        this.nextRecipeCategory.func_146112_a(minecraft, mouseX, mouseY);
        this.previousRecipeCategory.func_146112_a(minecraft, mouseX, mouseY);
        this.nextPage.func_146112_a(minecraft, mouseX, mouseY);
        this.previousPage.func_146112_a(minecraft, mouseX, mouseY);
        GlStateManager.func_179084_k();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        GlStateManager.func_179084_k();
        RecipesGui.func_73734_a((int)(8 + this.buttonWidth), (int)6, (int)(this.xSize - 8 - this.buttonWidth), (int)18, (int)0x30000000);
        RecipesGui.func_73734_a((int)(8 + this.buttonWidth), (int)(this.titleHeight + 5 - 2), (int)(this.xSize - 8 - this.buttonWidth), (int)(this.titleHeight + 5 + 10), (int)0x30000000);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        StringUtil.drawCenteredString(this.field_146289_q, this.title, this.xSize, 8, Color.WHITE.getRGB(), true);
        StringUtil.drawCenteredString(this.field_146289_q, this.pageString, this.xSize, this.titleHeight + 5, Color.WHITE.getRGB(), true);
        GlStateManager.func_179121_F();
        RecipeLayout hovered = null;
        for (RecipeLayout recipeWidget : this.recipeLayouts) {
            if (recipeWidget.getFocusUnderMouse(mouseX, mouseY) != null) {
                hovered = recipeWidget;
                continue;
            }
            recipeWidget.draw(minecraft, mouseX, mouseY);
        }
        if (hovered != null) {
            hovered.draw(minecraft, mouseX, mouseY);
        }
        if (this.titleHoverChecker.checkHover(mouseX, mouseY) && (focus = this.logic.getFocus()) != null && !focus.isBlank()) {
            String showAllRecipesString = Translator.translateToLocal("jei.tooltip.show.all.recipes");
            TooltipRenderer.drawHoveringText(minecraft, showAllRecipesString, mouseX, mouseY);
        }
    }

    public void drawBackground() {
        this.field_73735_i = -100.0f;
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.backgroundTexture);
        int x = (this.field_146294_l - this.xSize) / 2;
        int y = (this.field_146295_m - this.ySize) / 2;
        this.field_73735_i = 0.0f;
        this.func_73729_b(x, y, 0, 0, this.xSize, this.ySize);
    }

    private void bindTexture(ResourceLocation texturePath) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(texturePath);
    }
}

