/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import javax.annotation.Nonnull;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.config.Config;
import mezz.jei.gui.Focus;
import mezz.jei.gui.RecipeTransferButton;
import mezz.jei.gui.ingredients.GuiFluidStackGroup;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;

public class RecipeLayout
implements IRecipeLayout {
    private static final int RECIPE_BUTTON_SIZE = 12;
    public static final int recipeTransferButtonIndex = 100;
    @Nonnull
    private final IRecipeCategory recipeCategory;
    @Nonnull
    private final GuiItemStackGroup guiItemStackGroup;
    @Nonnull
    private final GuiFluidStackGroup guiFluidStackGroup;
    @Nonnull
    private final RecipeTransferButton recipeTransferButton;
    @Nonnull
    private final IRecipeWrapper recipeWrapper;
    private final int posX;
    private final int posY;

    public RecipeLayout(int index, int posX, int posY, @Nonnull IRecipeCategory recipeCategory, @Nonnull IRecipeWrapper recipeWrapper, @Nonnull Focus focus) {
        this.recipeCategory = recipeCategory;
        this.guiItemStackGroup = new GuiItemStackGroup();
        this.guiFluidStackGroup = new GuiFluidStackGroup();
        int width = recipeCategory.getBackground().getWidth();
        int height = recipeCategory.getBackground().getHeight();
        this.recipeTransferButton = new RecipeTransferButton(100 + index, posX + width + 2, posY + height - 12, 12, 12, "+");
        this.posX = posX;
        this.posY = posY;
        this.recipeWrapper = recipeWrapper;
        this.guiItemStackGroup.setFocus(focus);
        this.guiFluidStackGroup.setFocus(focus);
        this.recipeCategory.setRecipe(this, recipeWrapper);
    }

    public void draw(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.posX, (float)this.posY, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        IDrawable background = this.recipeCategory.getBackground();
        background.draw(minecraft);
        this.recipeCategory.drawExtras(minecraft);
        if (Config.isRecipeAnimationsEnabled()) {
            this.recipeCategory.drawAnimations(minecraft);
            this.recipeWrapper.drawAnimations(minecraft, background.getWidth(), background.getHeight());
        }
        GlStateManager.func_179109_b((float)(-this.posX), (float)(-this.posY), (float)0.0f);
        this.recipeTransferButton.func_146112_a(minecraft, mouseX, mouseY);
        GlStateManager.func_179084_k();
        GlStateManager.func_179109_b((float)this.posX, (float)this.posY, (float)0.0f);
        this.recipeWrapper.drawInfo(minecraft, background.getWidth(), background.getHeight());
        RenderHelper.func_74520_c();
        Object hoveredItemStack = this.guiItemStackGroup.draw(minecraft, mouseX - this.posX, mouseY - this.posY);
        RenderHelper.func_74518_a();
        Object hoveredFluidStack = this.guiFluidStackGroup.draw(minecraft, mouseX - this.posX, mouseY - this.posY);
        if (hoveredItemStack != null) {
            RenderHelper.func_74520_c();
            ((GuiIngredient)hoveredItemStack).drawHovered(minecraft, mouseX - this.posX, mouseY - this.posY);
            RenderHelper.func_74518_a();
        }
        if (hoveredFluidStack != null) {
            ((GuiIngredient)hoveredFluidStack).drawHovered(minecraft, mouseX - this.posX, mouseY - this.posY);
        }
        GlStateManager.func_179121_F();
    }

    public Focus getFocusUnderMouse(int mouseX, int mouseY) {
        Focus focus = this.guiItemStackGroup.getFocusUnderMouse(mouseX - this.posX, mouseY - this.posY);
        if (focus == null) {
            focus = this.guiFluidStackGroup.getFocusUnderMouse(mouseX - this.posX, mouseY - this.posY);
        }
        return focus;
    }

    @Override
    @Nonnull
    public GuiItemStackGroup getItemStacks() {
        return this.guiItemStackGroup;
    }

    @Override
    @Nonnull
    public IGuiFluidStackGroup getFluidStacks() {
        return this.guiFluidStackGroup;
    }

    @Override
    public void setRecipeTransferButton(int posX, int posY) {
        this.recipeTransferButton.field_146128_h = posX + this.posX;
        this.recipeTransferButton.field_146129_i = posY + this.posY;
    }

    @Nonnull
    public RecipeTransferButton getRecipeTransferButton() {
        return this.recipeTransferButton;
    }

    @Nonnull
    public IRecipeWrapper getRecipeWrapper() {
        return this.recipeWrapper;
    }

    @Nonnull
    public IRecipeCategory getRecipeCategory() {
        return this.recipeCategory;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }
}

