/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.RecipeRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.Focus;
import mezz.jei.gui.IRecipeGuiLogic;
import mezz.jei.gui.RecipeLayout;
import mezz.jei.util.Log;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Container;

public class RecipeGuiLogic
implements IRecipeGuiLogic {
    @Nullable
    private State state = null;
    @Nonnull
    private final Stack<State> history = new Stack();
    @Nonnull
    private List<IRecipeCategory> recipeCategories = ImmutableList.of();
    @Nonnull
    private List<Object> recipes = Collections.emptyList();
    private int recipesPerPage = 0;

    @Override
    public boolean setFocus(@Nonnull Focus focus) {
        return this.setFocus(focus, true);
    }

    @Override
    public boolean back() {
        if (this.history.empty()) {
            return false;
        }
        State state = this.history.pop();
        if (this.setFocus(state.focus, false)) {
            this.state = state;
            return true;
        }
        return false;
    }

    private boolean setFocus(@Nonnull Focus focus, boolean saveHistory) {
        if (this.state != null && this.state.focus.equalsFocus(focus)) {
            return true;
        }
        List<IRecipeCategory> types = focus.getCategories();
        if (types.isEmpty()) {
            return false;
        }
        this.recipeCategories = types;
        int recipeCategoryIndex = 0;
        Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        if (container != null) {
            for (int i = 0; i < this.recipeCategories.size(); ++i) {
                IRecipeCategory recipeCategory = this.recipeCategories.get(i);
                if (Internal.getRecipeRegistry().getRecipeTransferHelper(container, recipeCategory) == null) continue;
                recipeCategoryIndex = i;
                break;
            }
        }
        if (this.state != null && saveHistory) {
            this.history.push(this.state);
        }
        this.state = new State(focus, recipeCategoryIndex, 0);
        this.updateRecipes();
        return true;
    }

    @Override
    public boolean setCategoryFocus() {
        IRecipeCategory recipeCategory = this.getRecipeCategory();
        if (recipeCategory == null) {
            return false;
        }
        if (this.state != null) {
            if (this.state.focus.isBlank()) {
                return false;
            }
            this.history.push(this.state);
        }
        this.recipeCategories = Internal.getRecipeRegistry().getRecipeCategories();
        int recipeCategoryIndex = this.recipeCategories.indexOf(recipeCategory);
        this.state = new State(new Focus(), recipeCategoryIndex, 0);
        this.updateRecipes();
        return true;
    }

    @Override
    public Focus getFocus() {
        if (this.state == null) {
            return null;
        }
        return this.state.focus;
    }

    @Override
    public void setRecipesPerPage(int recipesPerPage) {
        if (this.state == null) {
            return;
        }
        if (this.recipesPerPage != recipesPerPage) {
            int recipeIndex = this.state.pageIndex * this.recipesPerPage;
            this.state.pageIndex = recipeIndex / recipesPerPage;
            this.recipesPerPage = recipesPerPage;
            this.updateRecipes();
        }
    }

    private void updateRecipes() {
        if (this.state == null) {
            return;
        }
        IRecipeCategory recipeCategory = this.getRecipeCategory();
        this.recipes = this.state.focus.getRecipes(recipeCategory);
    }

    @Override
    public IRecipeCategory getRecipeCategory() {
        if (this.state == null || this.recipeCategories.size() == 0) {
            return null;
        }
        return this.recipeCategories.get(this.state.recipeCategoryIndex);
    }

    @Override
    @Nonnull
    public List<RecipeLayout> getRecipeWidgets(int posX, int posY, int spacingY) {
        if (this.state == null) {
            return Collections.emptyList();
        }
        ArrayList<RecipeLayout> recipeWidgets = new ArrayList<RecipeLayout>();
        IRecipeCategory recipeCategory = this.getRecipeCategory();
        if (recipeCategory == null) {
            return recipeWidgets;
        }
        RecipeRegistry recipeRegistry = Internal.getRecipeRegistry();
        int recipeWidgetIndex = 0;
        for (int recipeIndex = this.state.pageIndex * this.recipesPerPage; recipeIndex < this.recipes.size() && recipeWidgets.size() < this.recipesPerPage; ++recipeIndex) {
            Object recipe = this.recipes.get(recipeIndex);
            IRecipeHandler recipeHandler = recipeRegistry.getRecipeHandler(recipe.getClass());
            if (recipeHandler == null) {
                Log.error("Couldn't find recipe handler for recipe: {}", recipe);
                continue;
            }
            IRecipeWrapper recipeWrapper = recipeHandler.getRecipeWrapper(recipe);
            RecipeLayout recipeWidget = new RecipeLayout(recipeWidgetIndex++, posX, posY, recipeCategory, recipeWrapper, this.state.focus);
            recipeWidgets.add(recipeWidget);
            posY += spacingY;
        }
        return recipeWidgets;
    }

    @Override
    public void nextRecipeCategory() {
        if (this.state == null) {
            return;
        }
        int recipesTypesCount = this.recipeCategories.size();
        this.state.recipeCategoryIndex = (this.state.recipeCategoryIndex + 1) % recipesTypesCount;
        this.state.pageIndex = 0;
        this.updateRecipes();
    }

    @Override
    public boolean hasMultiplePages() {
        return this.recipes.size() > this.recipesPerPage;
    }

    @Override
    public void previousRecipeCategory() {
        if (this.state == null) {
            return;
        }
        int recipesTypesCount = this.recipeCategories.size();
        this.state.recipeCategoryIndex = (recipesTypesCount + this.state.recipeCategoryIndex - 1) % recipesTypesCount;
        this.state.pageIndex = 0;
        this.updateRecipes();
    }

    @Override
    public void nextPage() {
        if (this.state == null) {
            return;
        }
        int pageCount = this.pageCount(this.recipesPerPage);
        this.state.pageIndex = (this.state.pageIndex + 1) % pageCount;
        this.updateRecipes();
    }

    @Override
    public void previousPage() {
        if (this.state == null) {
            return;
        }
        int pageCount = this.pageCount(this.recipesPerPage);
        this.state.pageIndex = (pageCount + this.state.pageIndex - 1) % pageCount;
        this.updateRecipes();
    }

    private int pageCount(int recipesPerPage) {
        if (this.recipes.size() <= 1) {
            return 1;
        }
        return MathUtil.divideCeil(this.recipes.size(), recipesPerPage);
    }

    @Override
    @Nonnull
    public String getPageString() {
        if (this.state == null) {
            return "1/1";
        }
        return this.state.pageIndex + 1 + "/" + this.pageCount(this.recipesPerPage);
    }

    @Override
    public boolean hasMultipleCategories() {
        return this.recipeCategories.size() > 1;
    }

    private static class State {
        @Nonnull
        public final Focus focus;
        public int recipeCategoryIndex;
        public int pageIndex;

        public State(@Nonnull Focus focus, int recipeCategoryIndex, int pageIndex) {
            this.focus = focus;
            this.recipeCategoryIndex = recipeCategoryIndex;
            this.pageIndex = pageIndex;
        }
    }
}

