/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.ItemFilter;
import mezz.jei.JustEnoughItems;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.config.Config;
import mezz.jei.config.Constants;
import mezz.jei.config.JEIModConfigGui;
import mezz.jei.gui.Focus;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.GuiItemStackFast;
import mezz.jei.gui.ingredients.GuiItemStackFastList;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.input.GuiTextFieldFilter;
import mezz.jei.input.IKeyable;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.network.packets.PacketDeletePlayerItem;
import mezz.jei.util.ItemStackElement;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.HoverChecker;
import org.lwjgl.input.Keyboard;

public class ItemListOverlay
implements IShowsRecipeFocuses,
IMouseHandler,
IKeyable {
    private static final int borderPadding = 4;
    private static final int searchHeight = 16;
    private static final int buttonPaddingX = 14;
    private static final int buttonPaddingY = 8;
    private static final int itemStackPadding = 1;
    private static final int itemStackWidth = GuiItemStackGroup.getWidth(1);
    private static final int itemStackHeight = GuiItemStackGroup.getHeight(1);
    private static int pageNum = 0;
    private final ItemFilter itemFilter;
    private int buttonHeight;
    private final GuiItemStackFastList guiItemStacks = new GuiItemStackFastList();
    private GuiButton nextButton;
    private GuiButton backButton;
    private GuiButton configButton;
    private IDrawable configButtonIcon;
    private HoverChecker configButtonHoverChecker;
    private GuiTextFieldFilter searchField;
    private int pageCount;
    private String pageNumDisplayString;
    private int pageNumDisplayX;
    private int pageNumDisplayY;
    private GuiItemStackFast hovered = null;
    private int guiLeft;
    private int guiXSize;
    private int screenWidth;
    private int screenHeight;
    private boolean open = false;
    private boolean enabled = true;

    public ItemListOverlay(ItemFilter itemFilter) {
        this.itemFilter = itemFilter;
    }

    public boolean initGui(@Nonnull GuiContainer guiContainer) {
        this.guiLeft = guiContainer.field_147003_i;
        this.guiXSize = guiContainer.field_146999_f;
        this.screenWidth = guiContainer.field_146294_l;
        this.screenHeight = guiContainer.field_146295_m;
        int columns = this.getColumns();
        if (columns < 4) {
            this.close();
            return false;
        }
        String next = ">";
        String back = "<";
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int nextButtonWidth = 14 + fontRenderer.func_78256_a(next);
        int backButtonWidth = 14 + fontRenderer.func_78256_a(back);
        this.buttonHeight = 8 + fontRenderer.field_78288_b;
        int rows = this.getRows();
        int xSize = columns * itemStackWidth;
        int xEmptySpace = this.screenWidth - this.guiLeft - this.guiXSize - xSize;
        int leftEdge = this.guiLeft + this.guiXSize + xEmptySpace / 2;
        int rightEdge = leftEdge + xSize;
        int yItemButtonSpace = this.getItemButtonYSpace();
        int itemButtonsHeight = rows * itemStackHeight;
        int buttonStartY = this.buttonHeight + 8 + (yItemButtonSpace - itemButtonsHeight) / 2;
        this.createItemButtons(leftEdge, buttonStartY, columns, rows);
        this.nextButton = new GuiButtonExt(0, rightEdge - nextButtonWidth, 4, nextButtonWidth, this.buttonHeight, next);
        this.backButton = new GuiButtonExt(1, leftEdge, 4, backButtonWidth, this.buttonHeight, back);
        int configButtonSize = 20;
        int configButtonX = rightEdge - configButtonSize + 1;
        int configButtonY = this.screenHeight - configButtonSize - 4;
        this.configButton = new GuiButtonExt(2, configButtonX, configButtonY, configButtonSize, configButtonSize, null);
        ResourceLocation configButtonIconLocation = new ResourceLocation(Constants.RESOURCE_DOMAIN, "textures/gui/recipeBackground.png");
        this.configButtonIcon = Internal.getHelpers().getGuiHelper().createDrawable(configButtonIconLocation, 0, 166, 16, 16);
        this.configButtonHoverChecker = new HoverChecker(this.configButton, 0);
        int searchFieldY = this.screenHeight - 16 - 4 - 2;
        int searchFieldWidth = rightEdge - leftEdge - configButtonSize - 1;
        this.searchField = new GuiTextFieldFilter(0, fontRenderer, leftEdge, searchFieldY, searchFieldWidth, 16);
        this.setKeyboardFocus(false);
        this.searchField.setItemFilter(this.itemFilter);
        this.updateLayout();
        return true;
    }

    private void createItemButtons(int xStart, int yStart, int columnCount, int rowCount) {
        this.guiItemStacks.clear();
        for (int row = 0; row < rowCount; ++row) {
            int y = yStart + row * itemStackHeight;
            for (int column = 0; column < columnCount; ++column) {
                int x = xStart + column * itemStackWidth;
                this.guiItemStacks.add(new GuiItemStackFast(x, y, 1));
            }
        }
    }

    private void updateLayout() {
        this.updatePageCount();
        if (pageNum >= this.getPageCount()) {
            pageNum = 0;
        }
        int i = pageNum * this.getCountPerPage();
        ImmutableList<ItemStackElement> itemList = this.itemFilter.getItemList();
        this.guiItemStacks.set(i, (List<ItemStackElement>)itemList);
        FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
        this.pageNumDisplayString = this.getPageNum() + 1 + "/" + this.getPageCount();
        int pageDisplayWidth = fontRendererObj.func_78256_a(this.pageNumDisplayString);
        this.pageNumDisplayX = (this.backButton.field_146128_h + this.backButton.field_146120_f + this.nextButton.field_146128_h) / 2 - pageDisplayWidth / 2;
        this.pageNumDisplayY = this.backButton.field_146129_i + Math.round((float)(this.backButton.field_146121_g - fontRendererObj.field_78288_b) / 2.0f);
        this.searchField.update();
    }

    private void nextPage() {
        if (pageNum == this.getPageCount() - 1) {
            this.setPageNum(0);
        } else {
            this.setPageNum(pageNum + 1);
        }
    }

    private void previousPage() {
        if (pageNum == 0) {
            this.setPageNum(this.getPageCount() - 1);
        } else {
            this.setPageNum(pageNum - 1);
        }
    }

    public void drawScreen(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
        if (!this.isOpen()) {
            return;
        }
        GlStateManager.func_179140_f();
        minecraft.field_71466_p.func_175065_a(this.pageNumDisplayString, (float)this.pageNumDisplayX, (float)this.pageNumDisplayY, Color.white.getRGB(), true);
        this.searchField.func_146194_f();
        this.nextButton.func_146112_a(minecraft, mouseX, mouseY);
        this.backButton.func_146112_a(minecraft, mouseX, mouseY);
        this.configButton.func_146112_a(minecraft, mouseX, mouseY);
        this.configButtonIcon.draw(minecraft, this.configButton.field_146128_h + 2, this.configButton.field_146129_i + 2);
        GlStateManager.func_179084_k();
        boolean mouseOver = this.isMouseOver(mouseX, mouseY);
        if (mouseOver && this.shouldShowDeleteItemTooltip(minecraft)) {
            this.hovered = this.guiItemStacks.render(null, minecraft, false, mouseX, mouseY);
            String deleteItem = Translator.translateToLocal("jei.tooltip.delete.item");
            TooltipRenderer.drawHoveringText(minecraft, deleteItem, mouseX, mouseY);
        } else {
            this.hovered = this.guiItemStacks.render(this.hovered, minecraft, mouseOver, mouseX, mouseY);
        }
        if (this.configButtonHoverChecker.checkHover(mouseX, mouseY)) {
            String configString = Translator.translateToLocal("jei.tooltip.config");
            TooltipRenderer.drawHoveringText(minecraft, configString, mouseX, mouseY);
        }
    }

    private boolean shouldShowDeleteItemTooltip(Minecraft minecraft) {
        if (Config.isDeleteItemsInCheatModeActive()) {
            EntityPlayerSP player = minecraft.field_71439_g;
            if (player.field_71071_by.func_70445_o() != null) {
                return true;
            }
        }
        return false;
    }

    public void drawHovered(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
        if (this.hovered != null) {
            RenderHelper.func_74520_c();
            this.hovered.drawHovered(minecraft, mouseX, mouseY);
            RenderHelper.func_74518_a();
            this.hovered = null;
        }
    }

    public void handleTick() {
        if (this.searchField != null) {
            this.searchField.func_146178_a();
        }
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.isOpen() && mouseX >= this.guiLeft + this.guiXSize;
    }

    @Override
    @Nullable
    public Focus getFocusUnderMouse(int mouseX, int mouseY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return null;
        }
        Focus focus = this.guiItemStacks.getFocusUnderMouse(mouseX, mouseY);
        if (focus != null) {
            this.setKeyboardFocus(false);
        }
        return focus;
    }

    @Override
    public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean buttonClicked;
        if (!this.isMouseOver(mouseX, mouseY)) {
            this.setKeyboardFocus(false);
            return false;
        }
        if (Config.isDeleteItemsInCheatModeActive()) {
            Minecraft minecraft = Minecraft.func_71410_x();
            EntityPlayerSP player = minecraft.field_71439_g;
            ItemStack itemStack = player.field_71071_by.func_70445_o();
            if (itemStack != null) {
                player.field_71071_by.func_70437_b(null);
                PacketDeletePlayerItem packet = new PacketDeletePlayerItem(itemStack);
                JustEnoughItems.getProxy().sendPacketToServer(packet);
                return true;
            }
        }
        if (buttonClicked = this.handleMouseClickedButtons(mouseX, mouseY)) {
            this.setKeyboardFocus(false);
            return true;
        }
        return this.handleMouseClickedSearch(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean handleMouseScrolled(int mouseX, int mouseY, int scrollDelta) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (scrollDelta < 0) {
            this.nextPage();
            return true;
        }
        if (scrollDelta > 0) {
            this.previousPage();
            return true;
        }
        return false;
    }

    private boolean handleMouseClickedButtons(int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (this.nextButton.func_146116_c(minecraft, mouseX, mouseY)) {
            this.nextPage();
            return true;
        }
        if (this.backButton.func_146116_c(minecraft, mouseX, mouseY)) {
            this.previousPage();
            return true;
        }
        if (this.configButton.func_146116_c(minecraft, mouseX, mouseY)) {
            this.close();
            JEIModConfigGui configScreen = new JEIModConfigGui(minecraft.field_71462_r);
            minecraft.func_147108_a((GuiScreen)configScreen);
            return true;
        }
        return false;
    }

    private boolean handleMouseClickedSearch(int mouseX, int mouseY, int mouseButton) {
        boolean searchClicked = this.searchField.isMouseOver(mouseX, mouseY);
        this.setKeyboardFocus(searchClicked);
        if (searchClicked && this.searchField.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            this.updateLayout();
        }
        return searchClicked;
    }

    @Override
    public boolean hasKeyboardFocus() {
        return this.searchField != null && this.searchField.func_146206_l();
    }

    @Override
    public void setKeyboardFocus(boolean keyboardFocus) {
        if (this.searchField != null) {
            this.searchField.func_146195_b(keyboardFocus);
        }
    }

    @Override
    public boolean onKeyPressed(int keyCode) {
        if (this.hasKeyboardFocus()) {
            boolean success = this.searchField.func_146201_a(Keyboard.getEventCharacter(), Keyboard.getEventKey());
            if (success) {
                this.updateLayout();
            }
            return true;
        }
        return false;
    }

    private int getItemButtonXSpace() {
        return this.screenWidth - (this.guiLeft + this.guiXSize + 8);
    }

    private int getItemButtonYSpace() {
        return this.screenHeight - (this.buttonHeight + 16 + 2 + 16);
    }

    private int getColumns() {
        return this.getItemButtonXSpace() / itemStackWidth;
    }

    private int getRows() {
        return this.getItemButtonYSpace() / itemStackHeight;
    }

    private int getCountPerPage() {
        return this.getColumns() * this.getRows();
    }

    private void updatePageCount() {
        int count = this.itemFilter.size();
        this.pageCount = MathUtil.divideCeil(count, this.getCountPerPage());
        if (this.pageCount == 0) {
            this.pageCount = 1;
        }
    }

    private int getPageCount() {
        return this.pageCount;
    }

    private int getPageNum() {
        return pageNum;
    }

    private void setPageNum(int pageNum) {
        if (ItemListOverlay.pageNum == pageNum) {
            return;
        }
        ItemListOverlay.pageNum = pageNum;
        this.updateLayout();
    }

    @Override
    public void open() {
        this.open = true;
        this.setKeyboardFocus(false);
    }

    @Override
    public void close() {
        this.open = false;
        this.setKeyboardFocus(false);
    }

    @Override
    public boolean isOpen() {
        return this.open && this.enabled;
    }

    public void toggleEnabled() {
        this.enabled = !this.enabled;
    }
}

