/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import java.io.File;
import java.util.Arrays;
import mezz.jei.util.Translator;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class LocalizedConfiguration {
    private static final String commentPostfix = ".comment";
    private final String keyPrefix;
    private final String defaultLocalized;
    private final String validLocalized;
    private final Configuration configuration;

    public LocalizedConfiguration(String keyPrefix, File file, String configVersion) {
        this.configuration = new Configuration(file, configVersion);
        this.keyPrefix = keyPrefix + '.';
        this.defaultLocalized = Translator.translateToLocal(this.keyPrefix + "default");
        this.validLocalized = Translator.translateToLocal(this.keyPrefix + "valid");
    }

    public void addCategory(String categoryName) {
        String categoryKey = this.keyPrefix + categoryName;
        String commentKey = categoryKey + commentPostfix;
        String comment = Translator.translateToLocal(commentKey);
        this.configuration.setCategoryComment(categoryName, comment);
        this.configuration.setCategoryLanguageKey(categoryName, categoryKey);
    }

    public ConfigCategory getCategory(String categoryName) {
        return this.configuration.getCategory(categoryName);
    }

    public boolean getBoolean(String category, String name, boolean defaultValue) {
        String langKey = this.keyPrefix + category + '.' + name;
        String commentKey = langKey + commentPostfix;
        String comment = Translator.translateToLocal(commentKey);
        return this.configuration.getBoolean(name, category, defaultValue, comment, langKey);
    }

    public String getString(String name, String category, String defaultValue) {
        String langKey = this.keyPrefix + category + '.' + name;
        String commentKey = langKey + commentPostfix;
        String comment = Translator.translateToLocal(commentKey);
        return this.configuration.getString(name, category, defaultValue, comment, langKey);
    }

    public String getString(String name, String category, String defaultValue, String[] validValues) {
        String langKey = this.keyPrefix + category + '.' + name;
        String commentKey = langKey + commentPostfix;
        String comment = Translator.translateToLocal(commentKey);
        Property prop = this.configuration.get(category, name, defaultValue);
        prop.setValidValues(validValues);
        prop.setLanguageKey(langKey);
        prop.comment = comment + " [" + this.defaultLocalized + ": " + defaultValue + "] [" + this.validLocalized + ": " + Arrays.toString(prop.getValidValues()) + ']';
        return prop.getString();
    }

    public <T extends Enum<T>> T getEnum(String name, String category, T defaultValue, T[] validEnumValues) {
        T enumValue;
        String langKey = this.keyPrefix + category + '.' + name;
        String commentKey = langKey + commentPostfix;
        String comment = Translator.translateToLocal(commentKey);
        Property prop = this.configuration.get(category, name, defaultValue.name());
        String[] validValues = new String[validEnumValues.length];
        for (int i = 0; i < validEnumValues.length; ++i) {
            enumValue = validEnumValues[i];
            validValues[i] = ((Enum)enumValue).name();
        }
        prop.setValidValues(validValues);
        prop.setLanguageKey(langKey);
        prop.comment = comment + " [" + this.defaultLocalized + ": " + defaultValue + "] [" + this.validLocalized + ": " + Arrays.toString(prop.getValidValues()) + ']';
        String stringValue = prop.getString();
        enumValue = defaultValue;
        for (int i = 0; i < validValues.length; ++i) {
            if (!stringValue.equals(validValues[i])) continue;
            enumValue = validEnumValues[i];
        }
        return enumValue;
    }

    public String[] getStringList(String name, String category, String[] defaultValue) {
        String langKey = this.keyPrefix + category + '.' + name;
        String commentKey = langKey + commentPostfix;
        String comment = Translator.translateToLocal(commentKey);
        Property prop = this.configuration.get(category, name, defaultValue);
        prop.setLanguageKey(langKey);
        prop.comment = comment + " [" + this.defaultLocalized + ": " + Arrays.toString(defaultValue) + ']';
        return prop.getStringList();
    }

    public String[] getStringList(String name, String category, String[] defaultValue, String[] validValues) {
        String langKey = this.keyPrefix + category + '.' + name;
        String commentKey = langKey + commentPostfix;
        String comment = Translator.translateToLocal(commentKey);
        Property prop = this.configuration.get(category, name, defaultValue);
        prop.setLanguageKey(langKey);
        prop.setValidValues(validValues);
        prop.comment = comment + " [" + this.defaultLocalized + ": " + Arrays.toString(defaultValue) + "] [" + this.validLocalized + ": " + Arrays.toString(prop.getValidValues()) + ']';
        return prop.getStringList();
    }

    public float getFloat(String name, String category, float defaultValue, float minValue, float maxValue) {
        String langKey = this.keyPrefix + category + '.' + name;
        String commentKey = langKey + commentPostfix;
        String comment = Translator.translateToLocal(commentKey);
        return this.configuration.getFloat(name, category, defaultValue, minValue, maxValue, comment, langKey);
    }

    public int getInt(String name, String category, int defaultValue, int minValue, int maxValue) {
        String langKey = this.keyPrefix + category + '.' + name;
        String commentKey = langKey + commentPostfix;
        String comment = Translator.translateToLocal(commentKey);
        return this.configuration.getInt(name, category, defaultValue, minValue, maxValue, comment, langKey);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean hasChanged() {
        return this.configuration.hasChanged();
    }

    public void save() {
        this.configuration.save();
    }

    public String toString() {
        return this.configuration.toString();
    }
}

