/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeTransferHelper;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.util.Log;
import mezz.jei.util.RecipeCategoryComparator;
import mezz.jei.util.RecipeMap;
import mezz.jei.util.StackUtil;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class RecipeRegistry
implements IRecipeRegistry {
    private final ImmutableMap<Class, IRecipeHandler> recipeHandlers;
    private final ImmutableTable<Class, String, IRecipeTransferHandler> recipeTransferHandlers;
    private final ImmutableMap<String, IRecipeCategory> recipeCategoriesMap;
    private final ListMultimap<IRecipeCategory, Object> recipesForCategories;
    private final RecipeMap recipeInputMap;
    private final RecipeMap recipeOutputMap;
    private final Set<Class> unhandledRecipeClasses;

    public RecipeRegistry(@Nonnull List<IRecipeCategory> recipeCategories, @Nonnull List<IRecipeHandler> recipeHandlers, @Nonnull List<IRecipeTransferHandler> recipeTransferHandlers, @Nonnull List<Object> recipes) {
        this.recipeCategoriesMap = RecipeRegistry.buildRecipeCategoriesMap(recipeCategories);
        this.recipeTransferHandlers = RecipeRegistry.buildRecipeTransferHandlerTable(recipeTransferHandlers);
        this.recipeHandlers = RecipeRegistry.buildRecipeHandlersMap(recipeHandlers);
        RecipeCategoryComparator recipeCategoryComparator = new RecipeCategoryComparator(recipeCategories);
        this.recipeInputMap = new RecipeMap(recipeCategoryComparator);
        this.recipeOutputMap = new RecipeMap(recipeCategoryComparator);
        this.unhandledRecipeClasses = new HashSet<Class>();
        this.recipesForCategories = ArrayListMultimap.create();
        this.addRecipes(recipes);
    }

    private static ImmutableMap<String, IRecipeCategory> buildRecipeCategoriesMap(@Nonnull List<IRecipeCategory> recipeCategories) {
        HashMap<String, IRecipeCategory> mutableRecipeCategoriesMap = new HashMap<String, IRecipeCategory>();
        for (IRecipeCategory recipeCategory : recipeCategories) {
            mutableRecipeCategoriesMap.put(recipeCategory.getUid(), recipeCategory);
        }
        return ImmutableMap.copyOf(mutableRecipeCategoriesMap);
    }

    private static ImmutableMap<Class, IRecipeHandler> buildRecipeHandlersMap(@Nonnull List<IRecipeHandler> recipeHandlers) {
        HashMap mutableRecipeHandlers = Maps.newHashMap();
        for (IRecipeHandler recipeHandler : recipeHandlers) {
            if (recipeHandler == null) continue;
            Class recipeClass = recipeHandler.getRecipeClass();
            if (mutableRecipeHandlers.containsKey(recipeClass)) {
                throw new IllegalArgumentException("A Recipe Handler has already been registered for this recipe class: " + recipeClass.getName());
            }
            mutableRecipeHandlers.put(recipeClass, recipeHandler);
        }
        return ImmutableMap.copyOf((Map)mutableRecipeHandlers);
    }

    private static ImmutableTable<Class, String, IRecipeTransferHandler> buildRecipeTransferHandlerTable(@Nonnull List<IRecipeTransferHandler> recipeTransferHandlers) {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (IRecipeTransferHandler recipeTransferHelper : recipeTransferHandlers) {
            builder.put(recipeTransferHelper.getContainerClass(), (Object)recipeTransferHelper.getRecipeCategoryUid(), (Object)recipeTransferHelper);
        }
        return builder.build();
    }

    private void addRecipes(@Nullable List<Object> recipes) {
        if (recipes == null) {
            return;
        }
        for (Object recipe : recipes) {
            this.addRecipe(recipe);
        }
    }

    @Override
    public void addRecipe(@Nullable Object recipe) {
        if (recipe == null) {
            Log.error("Null recipe", new NullPointerException());
            return;
        }
        Class<?> recipeClass = recipe.getClass();
        IRecipeHandler recipeHandler = this.getRecipeHandler(recipeClass);
        if (recipeHandler == null) {
            if (!this.unhandledRecipeClasses.contains(recipeClass)) {
                this.unhandledRecipeClasses.add(recipeClass);
                Log.debug("Can't handle recipe: {}", recipeClass);
            }
            return;
        }
        String recipeCategoryUid = recipeHandler.getRecipeCategoryUid();
        IRecipeCategory recipeCategory = (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
        if (recipeCategory == null) {
            Log.error("No recipe category registered for recipeCategoryUid: {}", recipeCategoryUid);
            return;
        }
        if (!recipeHandler.isRecipeValid(recipe)) {
            return;
        }
        try {
            this.addRecipeUnchecked(recipe, recipeCategory, recipeHandler);
        }
        catch (RuntimeException e) {
            String recipeInfo = this.getInfoFromBrokenRecipe(recipe, recipeHandler);
            Log.error("Failed to add recipe: {}", recipeInfo, e);
        }
    }

    @Nonnull
    private String getInfoFromBrokenRecipe(@Nonnull Object recipe, @Nonnull IRecipeHandler recipeHandler) {
        IRecipeWrapper recipeWrapper;
        StringBuilder recipeInfoBuilder = new StringBuilder();
        try {
            recipeInfoBuilder.append(recipe.toString());
        }
        catch (RuntimeException e) {
            Log.error("Failed recipe.toString", e);
            recipeInfoBuilder.append(recipe.getClass());
        }
        try {
            recipeWrapper = recipeHandler.getRecipeWrapper(recipe);
        }
        catch (RuntimeException ignored) {
            recipeInfoBuilder.append("\nFailed to create recipe wrapper");
            return recipeInfoBuilder.toString();
        }
        recipeInfoBuilder.append("\nOutput ItemStacks: ");
        try {
            recipeInfoBuilder.append(recipeWrapper.getOutputs());
        }
        catch (RuntimeException e) {
            recipeInfoBuilder.append(e.getMessage());
        }
        recipeInfoBuilder.append("\nOutput Fluids: ");
        try {
            recipeInfoBuilder.append(recipeWrapper.getFluidOutputs());
        }
        catch (RuntimeException e) {
            recipeInfoBuilder.append(e.getMessage());
        }
        recipeInfoBuilder.append("\nInput ItemStacks: ");
        try {
            recipeInfoBuilder.append(recipeWrapper.getInputs());
        }
        catch (RuntimeException e) {
            recipeInfoBuilder.append(e.getMessage());
        }
        recipeInfoBuilder.append("\nInput Fluids: ");
        try {
            recipeInfoBuilder.append(recipeWrapper.getFluidInputs());
        }
        catch (RuntimeException e) {
            recipeInfoBuilder.append(e.getMessage());
        }
        return recipeInfoBuilder.toString();
    }

    private void addRecipeUnchecked(@Nonnull Object recipe, IRecipeCategory recipeCategory, IRecipeHandler recipeHandler) {
        IRecipeWrapper recipeWrapper = recipeHandler.getRecipeWrapper(recipe);
        List inputs = recipeWrapper.getInputs();
        List<Object> fluidInputs = recipeWrapper.getFluidInputs();
        if (inputs != null || fluidInputs != null) {
            List<ItemStack> inputStacks = StackUtil.toItemStackList(inputs);
            if (fluidInputs == null) {
                fluidInputs = Collections.emptyList();
            }
            this.recipeInputMap.addRecipe(recipe, recipeCategory, inputStacks, fluidInputs);
        }
        List outputs = recipeWrapper.getOutputs();
        List<Object> fluidOutputs = recipeWrapper.getFluidOutputs();
        if (outputs != null || fluidOutputs != null) {
            List<ItemStack> outputStacks = StackUtil.toItemStackList(outputs);
            if (fluidOutputs == null) {
                fluidOutputs = Collections.emptyList();
            }
            this.recipeOutputMap.addRecipe(recipe, recipeCategory, outputStacks, fluidOutputs);
        }
        this.recipesForCategories.put((Object)recipeCategory, recipe);
    }

    @Nonnull
    public ImmutableList<IRecipeCategory> getRecipeCategories() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IRecipeCategory recipeCategory : this.recipeCategoriesMap.values()) {
            if (this.getRecipes(recipeCategory).isEmpty()) continue;
            builder.add((Object)recipeCategory);
        }
        return builder.build();
    }

    @Override
    @Nullable
    public IRecipeHandler getRecipeHandler(@Nullable Class recipeClass) {
        IRecipeHandler recipeHandler;
        if (recipeClass == null) {
            Log.error("Null recipeClass", new NullPointerException());
            return null;
        }
        while ((recipeHandler = (IRecipeHandler)this.recipeHandlers.get((Object)recipeClass)) == null && recipeClass != Object.class) {
            recipeClass = recipeClass.getSuperclass();
        }
        return recipeHandler;
    }

    @Nonnull
    public ImmutableList<IRecipeCategory> getRecipeCategoriesWithInput(@Nullable ItemStack input) {
        if (input == null) {
            Log.error("Null ItemStack input", new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeInputMap.getRecipeCategories(input);
    }

    @Nonnull
    public ImmutableList<IRecipeCategory> getRecipeCategoriesWithInput(@Nullable Fluid input) {
        if (input == null) {
            Log.error("Null Fluid input", new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeInputMap.getRecipeCategories(input);
    }

    @Nonnull
    public ImmutableList<IRecipeCategory> getRecipeCategoriesWithOutput(@Nullable ItemStack output) {
        if (output == null) {
            Log.error("Null ItemStack output", new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeOutputMap.getRecipeCategories(output);
    }

    @Nonnull
    public ImmutableList<IRecipeCategory> getRecipeCategoriesWithOutput(@Nullable Fluid output) {
        if (output == null) {
            Log.error("Null Fluid output", new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeOutputMap.getRecipeCategories(output);
    }

    @Nonnull
    public ImmutableList<Object> getRecipesWithInput(@Nullable IRecipeCategory recipeCategory, @Nullable ItemStack input) {
        if (recipeCategory == null) {
            Log.error("Null recipeCategory", new NullPointerException());
            return ImmutableList.of();
        }
        if (input == null) {
            Log.error("Null ItemStack input", new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeInputMap.getRecipes(recipeCategory, input);
    }

    @Override
    @Nonnull
    public List<Object> getRecipesWithInput(@Nullable IRecipeCategory recipeCategory, @Nullable Fluid input) {
        if (recipeCategory == null) {
            Log.error("Null recipeCategory", new NullPointerException());
            return ImmutableList.of();
        }
        if (input == null) {
            Log.error("Null Fluid input", new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeInputMap.getRecipes(recipeCategory, input);
    }

    @Nonnull
    public ImmutableList<Object> getRecipesWithOutput(@Nullable IRecipeCategory recipeCategory, @Nullable ItemStack output) {
        if (recipeCategory == null) {
            Log.error("Null recipeCategory", new NullPointerException());
            return ImmutableList.of();
        }
        if (output == null) {
            Log.error("Null ItemStack output", new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeOutputMap.getRecipes(recipeCategory, output);
    }

    @Override
    @Nonnull
    public List<Object> getRecipesWithOutput(@Nullable IRecipeCategory recipeCategory, @Nullable Fluid output) {
        if (recipeCategory == null) {
            return ImmutableList.of();
        }
        if (output == null) {
            Log.error("Null Fluid output", new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeOutputMap.getRecipes(recipeCategory, output);
    }

    @Override
    @Nonnull
    public List<Object> getRecipes(@Nullable IRecipeCategory recipeCategory) {
        if (recipeCategory == null) {
            Log.error("Null recipeCategory", new NullPointerException());
            return ImmutableList.of();
        }
        return Collections.unmodifiableList(this.recipesForCategories.get((Object)recipeCategory));
    }

    @Override
    @Nullable
    public IRecipeTransferHelper getRecipeTransferHelper(@Nullable Container container, @Nullable IRecipeCategory recipeCategory) {
        return null;
    }

    @Nullable
    public IRecipeTransferHandler getRecipeTransferHandler(@Nullable Container container, @Nullable IRecipeCategory recipeCategory) {
        if (container == null) {
            Log.error("Null container", new NullPointerException());
            return null;
        }
        if (recipeCategory == null) {
            Log.error("Null recipeCategory", new NullPointerException());
            return null;
        }
        return (IRecipeTransferHandler)this.recipeTransferHandlers.get(container.getClass(), (Object)recipeCategory.getUid());
    }
}

