/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.GuiEventHandler;
import mezz.jei.Internal;
import mezz.jei.ItemFilter;
import mezz.jei.ItemRegistry;
import mezz.jei.ProxyCommon;
import mezz.jei.RecipeRegistry;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JEIManager;
import mezz.jei.config.Config;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.ItemListOverlay;
import mezz.jei.network.packets.PacketJEI;
import mezz.jei.util.AnnotatedInstanceUtil;
import mezz.jei.util.Log;
import mezz.jei.util.ModRegistry;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ProxyCommonClient
extends ProxyCommon {
    private static boolean started = false;
    @Nullable
    private ItemFilter itemFilter;
    private GuiEventHandler guiEventHandler;
    private List<IModPlugin> plugins;

    private static void initVersionChecker() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("curseProjectName", "just-enough-items-jei");
        compound.func_74778_a("curseFilenameParser", "jei_1.8.9-[].jar");
        FMLInterModComms.sendRuntimeMessage((Object)"JEI", (String)"VersionChecker", (String)"addCurseCheck", (NBTTagCompound)compound);
    }

    @Override
    public void preInit(@Nonnull FMLPreInitializationEvent event) {
        Config.preInit(event);
        ProxyCommonClient.initVersionChecker();
        ASMDataTable asmDataTable = event.getAsmData();
        this.plugins = AnnotatedInstanceUtil.getModPlugins(asmDataTable);
        Iterator<IModPlugin> iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                plugin.onJeiHelpersAvailable(Internal.getHelpers());
            }
            catch (AbstractMethodError abstractMethodError) {
            }
            catch (Exception e) {
                Log.error("Mod plugin failed: {}", plugin.getClass(), e);
                iterator.remove();
            }
        }
    }

    @Override
    public void init(@Nonnull FMLInitializationEvent event) {
        KeyBindings.init();
        FMLCommonHandler.instance().bus().register((Object)this);
        this.guiEventHandler = new GuiEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)this.guiEventHandler);
        FMLCommonHandler.instance().bus().register((Object)this.guiEventHandler);
    }

    @Override
    public void startJEI() {
        started = true;
        ItemRegistry itemRegistry = new ItemRegistry();
        JEIManager.itemRegistry = itemRegistry;
        Internal.setItemRegistry(itemRegistry);
        Iterator<IModPlugin> iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                plugin.onItemRegistryAvailable(itemRegistry);
            }
            catch (AbstractMethodError abstractMethodError) {
            }
            catch (Exception e) {
                Log.error("Mod plugin failed: {}", plugin.getClass(), e);
                iterator.remove();
            }
        }
        ModRegistry modRegistry = new ModRegistry();
        iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                plugin.register(modRegistry);
                Log.info("Registered plugin: {}", plugin.getClass().getName());
            }
            catch (Exception e) {
                Log.error("Failed to register mod plugin: {}", plugin.getClass(), e);
                iterator.remove();
            }
        }
        RecipeRegistry recipeRegistry = modRegistry.createRecipeRegistry();
        JEIManager.recipeRegistry = recipeRegistry;
        Internal.setRecipeRegistry(recipeRegistry);
        iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                plugin.onRecipeRegistryAvailable(recipeRegistry);
            }
            catch (AbstractMethodError abstractMethodError) {
            }
            catch (Exception e) {
                Log.error("Mod plugin failed: {}", plugin.getClass(), e);
                iterator.remove();
            }
        }
        this.itemFilter = new ItemFilter(itemRegistry);
        ItemListOverlay itemListOverlay = new ItemListOverlay(this.itemFilter);
        this.guiEventHandler.setItemListOverlay(itemListOverlay);
    }

    private void restartJEI() {
        if (started) {
            this.startJEI();
        }
    }

    @Override
    public void resetItemFilter() {
        if (this.itemFilter != null) {
            this.itemFilter.reset();
        }
    }

    @Override
    public void sendPacketToServer(PacketJEI packet) {
        NetHandlerPlayClient netHandler = FMLClientHandler.instance().getClient().func_147114_u();
        if (netHandler != null) {
            netHandler.func_147297_a((Packet)packet.getPacket());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onConfigChanged(@Nonnull ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (!"JEI".equals(eventArgs.modID)) {
            return;
        }
        if (Config.syncConfig()) {
            this.restartJEI();
        }
    }
}

