/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.INbtIgnoreList;
import mezz.jei.config.Config;
import mezz.jei.util.Log;

public class NbtIgnoreList
implements INbtIgnoreList {
    private final Set<String> nbtTagNameBlacklist = new HashSet<String>();

    @Override
    public void ignoreNbtTagNames(String ... nbtTagNames) {
        Collections.addAll(this.nbtTagNameBlacklist, nbtTagNames);
    }

    @Override
    public boolean isNbtTagIgnored(@Nullable String nbtTagName) {
        if (nbtTagName == null) {
            Log.error("Null nbtTagName", new NullPointerException());
            return false;
        }
        return Config.getNbtKeyIgnoreList().contains(nbtTagName) || this.nbtTagNameBlacklist.contains(nbtTagName);
    }

    @Override
    @Nonnull
    public Set<String> getIgnoredNbtTags(@Nullable Set<String> nbtTagNames) {
        if (nbtTagNames == null) {
            Log.error("Null nbtTagNames", new NullPointerException());
            return Collections.emptySet();
        }
        Sets.SetView ignoredKeysConfig = Sets.intersection(nbtTagNames, Config.getNbtKeyIgnoreList());
        Sets.SetView ignoredKeysApi = Sets.intersection(nbtTagNames, this.nbtTagNameBlacklist);
        return Sets.union((Set)ignoredKeysConfig, (Set)ignoredKeysApi);
    }
}

