/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IItemRegistry;
import mezz.jei.util.Log;
import mezz.jei.util.ModList;
import mezz.jei.util.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ItemRegistry
implements IItemRegistry {
    @Nonnull
    private final Set<String> itemNameSet = new HashSet<String>();
    @Nonnull
    private final ImmutableList<ItemStack> itemList;
    @Nonnull
    private final ImmutableListMultimap<String, ItemStack> itemsByModId;
    @Nonnull
    private final ImmutableList<ItemStack> potionIngredients;
    @Nonnull
    private final ImmutableList<ItemStack> fuels;
    @Nonnull
    private final ModList modList = new ModList();

    public ItemRegistry() {
        ArrayList<ItemStack> itemListMutable = new ArrayList<ItemStack>();
        ArrayList<ItemStack> fuelsMutable = new ArrayList<ItemStack>();
        for (Block block : GameData.getBlockRegistry().typeSafeIterable()) {
            this.addBlockAndSubBlocks(block, itemListMutable, fuelsMutable);
        }
        for (Object item : GameData.getItemRegistry().typeSafeIterable()) {
            this.addItemAndSubItems((Item)item, itemListMutable, fuelsMutable);
        }
        this.addEnchantedBooks(itemListMutable);
        this.itemList = ImmutableList.copyOf(itemListMutable);
        this.fuels = ImmutableList.copyOf(fuelsMutable);
        ImmutableListMultimap.Builder itemsByModIdBuilder = ImmutableListMultimap.builder();
        for (ItemStack itemStack : itemListMutable) {
            Item item = itemStack.func_77973_b();
            if (item == null) continue;
            String modId = GameRegistry.findUniqueIdentifierFor((Item)item).modId.toLowerCase(Locale.ENGLISH);
            itemsByModIdBuilder.put((Object)modId, (Object)itemStack);
        }
        this.itemsByModId = itemsByModIdBuilder.build();
        ImmutableList.Builder potionIngredientBuilder = ImmutableList.builder();
        for (ItemStack itemStack : this.itemList) {
            if (!itemStack.func_77973_b().func_150892_m(itemStack)) continue;
            potionIngredientBuilder.add((Object)itemStack);
        }
        this.potionIngredients = potionIngredientBuilder.build();
    }

    private void addEnchantedBooks(List<ItemStack> itemList) {
        for (Enchantment enchantment : Enchantment.field_77331_b) {
            if (enchantment == null || enchantment.field_77351_y == null) continue;
            EnchantmentData enchantmentData = new EnchantmentData(enchantment, enchantment.func_77325_b());
            ItemStack enchantedBook = Items.field_151134_bR.func_92111_a(enchantmentData);
            itemList.add(enchantedBook);
        }
    }

    @Override
    @Nonnull
    public ImmutableList<ItemStack> getItemList() {
        return this.itemList;
    }

    @Override
    @Nonnull
    public ImmutableList<ItemStack> getFuels() {
        return this.fuels;
    }

    @Override
    @Nonnull
    public ImmutableList<ItemStack> getPotionIngredients() {
        return this.potionIngredients;
    }

    @Override
    @Nonnull
    public String getModNameForItem(@Nullable Item item) {
        if (item == null) {
            Log.error("Null item", new NullPointerException());
            return "";
        }
        return this.modList.getModNameForItem(item);
    }

    @Override
    @Nonnull
    public ImmutableList<ItemStack> getItemListForModId(@Nullable String modId) {
        if (modId == null) {
            Log.error("Null modId", new NullPointerException());
            return ImmutableList.of();
        }
        String lowerCaseModId = modId.toLowerCase(Locale.ENGLISH);
        return this.itemsByModId.get((Object)lowerCaseModId);
    }

    private void addItemAndSubItems(@Nullable Item item, @Nonnull List<ItemStack> itemList, @Nonnull List<ItemStack> fuels) {
        if (item == null) {
            return;
        }
        List<ItemStack> items = StackUtil.getSubtypes(item);
        this.addItemStacks(items, itemList, fuels);
    }

    private void addBlockAndSubBlocks(@Nullable Block block, @Nonnull List<ItemStack> itemList, @Nonnull List<ItemStack> fuels) {
        if (block == null) {
            return;
        }
        Item item = Item.func_150898_a((Block)block);
        if (item == null) {
            Log.debug("Couldn't get itemStack for block: {}", block.func_149739_a());
            return;
        }
        ArrayList<ItemStack> subItems = new ArrayList<ItemStack>();
        for (CreativeTabs itemTab : item.getCreativeTabs()) {
            subItems.clear();
            block.func_149666_a(item, itemTab, subItems);
            this.addItemStacks(subItems, itemList, fuels);
            if (!subItems.isEmpty()) continue;
            ItemStack stack = new ItemStack(block);
            if (stack.func_77973_b() == null) {
                Log.debug("Couldn't get itemStack for block: {}", block.func_149739_a());
                return;
            }
            this.addItemStack(stack, itemList, fuels);
        }
    }

    private void addItemStacks(@Nonnull Iterable<ItemStack> stacks, @Nonnull List<ItemStack> itemList, @Nonnull List<ItemStack> fuels) {
        for (ItemStack stack : stacks) {
            if (stack == null) continue;
            this.addItemStack(stack, itemList, fuels);
        }
    }

    private void addItemStack(@Nonnull ItemStack stack, @Nonnull List<ItemStack> itemList, @Nonnull List<ItemStack> fuels) {
        try {
            String itemKey = StackUtil.getUniqueIdentifierForStack(stack);
            if (this.itemNameSet.contains(itemKey)) {
                return;
            }
            this.itemNameSet.add(itemKey);
            itemList.add(stack);
            if (TileEntityFurnace.func_145954_b((ItemStack)stack)) {
                fuels.add(stack);
            }
        }
        catch (RuntimeException e) {
            Log.error("Couldn't create unique name for itemStack {}.", stack.getClass(), e);
        }
    }
}

