/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.IItemBlacklist;
import mezz.jei.api.IItemRegistry;
import mezz.jei.config.Config;
import mezz.jei.util.ItemStackElement;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemStack;

public class ItemFilter {
    @Nonnull
    private static String filterText = "";
    private final LoadingCache<String, ImmutableList<ItemStackElement>> filteredItemMapsCache;

    public ItemFilter(IItemRegistry itemRegistry) {
        this.filteredItemMapsCache = CacheBuilder.newBuilder().maximumWeight(16L).weigher((Weigher)new SearchFilterWeigher()).concurrencyLevel(1).build((CacheLoader)new ItemFilterCacheLoader(itemRegistry));
        this.filteredItemMapsCache.getUnchecked((Object)"");
    }

    public void reset() {
        this.filteredItemMapsCache.invalidateAll();
    }

    public static boolean setFilterText(@Nonnull String filterText) {
        String lowercaseFilterText = filterText.toLowerCase();
        if (ItemFilter.filterText.equals(lowercaseFilterText)) {
            return false;
        }
        ItemFilter.filterText = lowercaseFilterText;
        return true;
    }

    @Nonnull
    public String getFilterText() {
        return filterText;
    }

    @Nonnull
    public ImmutableList<ItemStackElement> getItemList() {
        String[] filters = filterText.split("\\|");
        if (filters.length == 1) {
            String filter = filters[0];
            return (ImmutableList)this.filteredItemMapsCache.getUnchecked((Object)filter);
        }
        ImmutableList.Builder itemList = ImmutableList.builder();
        for (String filter : filters) {
            List itemStackElements = (List)this.filteredItemMapsCache.getUnchecked((Object)filter);
            itemList.addAll((Iterable)itemStackElements);
        }
        return itemList.build();
    }

    public int size() {
        return this.getItemList().size();
    }

    private static ImmutableList<ItemStackElement> createBaseList(IItemRegistry itemRegistry) {
        ItemStackChecker itemStackChecker = new ItemStackChecker();
        ImmutableList.Builder baseList = ImmutableList.builder();
        for (ItemStack itemStack : itemRegistry.getItemList()) {
            ItemStackElement itemStackElement;
            if (itemStack == null || itemStackChecker.isItemStackHidden(itemStack) || (itemStackElement = ItemStackElement.create(itemStack)) == null) continue;
            baseList.add((Object)itemStackElement);
        }
        return baseList.build();
    }

    private static class FilterPredicate
    implements Predicate<ItemStackElement> {
        private final List<String> itemNameTokens = new ArrayList<String>();
        private final List<String> modNameTokens = new ArrayList<String>();

        public FilterPredicate(String filterText) {
            String[] tokens;
            for (String token : tokens = filterText.split(" ")) {
                if (token.startsWith("@")) {
                    String modNameToken = token.substring(1);
                    this.modNameTokens.add(modNameToken);
                    continue;
                }
                this.itemNameTokens.add(token);
            }
        }

        public boolean apply(@Nullable ItemStackElement input) {
            if (input == null) {
                return false;
            }
            String modName = input.getModName();
            for (String token : this.modNameTokens) {
                if (modName.contains(token)) continue;
                return false;
            }
            String itemName = input.getSearchString();
            for (String token : this.itemNameTokens) {
                if (itemName.contains(token)) continue;
                return false;
            }
            return true;
        }
    }

    private static class ItemStackChecker {
        private IItemBlacklist itemBlacklist = Internal.getHelpers().getItemBlacklist();
        private ItemModelMesher itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        private IBakedModel missingModel = this.itemModelMesher.func_178083_a().func_174951_a();

        public boolean isItemStackHidden(@Nonnull ItemStack itemStack) {
            if (this.isItemStackHiddenByMissingModel(itemStack)) {
                return true;
            }
            return this.isItemHiddenByBlacklist(itemStack);
        }

        private boolean isItemStackHiddenByMissingModel(@Nonnull ItemStack itemStack) {
            if (!Config.isHideMissingModelsEnabled()) {
                return false;
            }
            try {
                if (this.itemModelMesher.func_178089_a(itemStack) == this.missingModel) {
                    return true;
                }
            }
            catch (RuntimeException e) {
                Log.error("Couldn't get ItemModel for itemStack {}.", itemStack.getClass(), e);
                return true;
            }
            return false;
        }

        private boolean isItemHiddenByBlacklist(@Nonnull ItemStack itemStack) {
            if (!this.itemBlacklist.isItemBlacklisted(itemStack)) {
                return false;
            }
            if (Config.isEditModeEnabled()) {
                return !Config.isItemOnConfigBlacklist(itemStack, true) && !Config.isItemOnConfigBlacklist(itemStack, false);
            }
            return true;
        }
    }

    private class ItemFilterCacheLoader
    extends CacheLoader<String, ImmutableList<ItemStackElement>> {
        private final IItemRegistry itemRegistry;

        public ItemFilterCacheLoader(IItemRegistry itemRegistry) {
            this.itemRegistry = itemRegistry;
        }

        public ImmutableList<ItemStackElement> load(@Nonnull String filterText) throws Exception {
            if (filterText.length() == 0) {
                return ItemFilter.createBaseList(this.itemRegistry);
            }
            String prevFilterText = filterText.substring(0, filterText.length() - 1);
            ImmutableList baseItemSet = (ImmutableList)ItemFilter.this.filteredItemMapsCache.get((Object)prevFilterText);
            FilterPredicate filterPredicate = new FilterPredicate(filterText);
            ImmutableList.Builder itemStackElementsBuilder = ImmutableList.builder();
            for (ItemStackElement itemStackElement : baseItemSet) {
                if (!filterPredicate.apply(itemStackElement)) continue;
                itemStackElementsBuilder.add((Object)itemStackElement);
            }
            return itemStackElementsBuilder.build();
        }
    }

    private static class SearchFilterWeigher
    implements Weigher<String, ImmutableList<ItemStackElement>> {
        private SearchFilterWeigher() {
        }

        public int weigh(@Nonnull String key, @Nonnull ImmutableList<ItemStackElement> value) {
            return key.length() == 0 ? 0 : 1;
        }
    }
}

