/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.gui.ItemListOverlay;
import mezz.jei.gui.RecipesGui;
import mezz.jei.input.InputHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Mouse;

public class GuiEventHandler {
    @Nullable
    private ItemListOverlay itemListOverlay;
    @Nonnull
    private final RecipesGui recipesGui = new RecipesGui();
    @Nullable
    private InputHandler inputHandler;

    public void setItemListOverlay(@Nullable ItemListOverlay itemListOverlay) {
        if (this.itemListOverlay != null) {
            this.itemListOverlay.close();
        }
        this.itemListOverlay = itemListOverlay;
        if (this.recipesGui.isOpen()) {
            this.recipesGui.close();
        }
    }

    @SubscribeEvent
    public void onGuiInit(@Nonnull GuiScreenEvent.InitGuiEvent.Post event) {
        if (this.itemListOverlay == null) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        GuiContainer guiContainer = this.asGuiContainer(minecraft.field_71462_r);
        if (guiContainer == null) {
            return;
        }
        if (this.itemListOverlay.initGui(guiContainer)) {
            this.itemListOverlay.open();
        }
        this.recipesGui.initGui(minecraft);
        this.inputHandler = new InputHandler(this.recipesGui, this.itemListOverlay, guiContainer);
    }

    @SubscribeEvent
    public void onGuiOpen(@Nonnull GuiOpenEvent event) {
        if (this.itemListOverlay == null) {
            return;
        }
        if (event.gui == null && this.itemListOverlay.isOpen()) {
            this.itemListOverlay.close();
        }
    }

    @SubscribeEvent
    public void onDrawScreenEventPre(@Nonnull GuiScreenEvent.DrawScreenEvent.Pre event) {
        GuiContainer guiContainer = this.asGuiContainer(event.gui);
        if (guiContainer == null) {
            return;
        }
        if (this.recipesGui.isOpen()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onDrawScreenEventPost(@Nonnull GuiScreenEvent.DrawScreenEvent.Post event) {
        Slot slotUnderMouse;
        if (this.itemListOverlay == null) {
            return;
        }
        GuiContainer guiContainer = this.asGuiContainer(event.gui);
        if (guiContainer == null) {
            return;
        }
        if (this.recipesGui.isOpen()) {
            this.recipesGui.drawBackground();
        }
        this.itemListOverlay.drawScreen(guiContainer.field_146297_k, event.mouseX, event.mouseY);
        if (this.recipesGui.isOpen()) {
            this.recipesGui.draw(event.mouseX, event.mouseY);
        }
        this.itemListOverlay.drawHovered(guiContainer.field_146297_k, event.mouseX, event.mouseY);
        if (!this.recipesGui.isOpen() && (slotUnderMouse = guiContainer.getSlotUnderMouse()) != null && slotUnderMouse.func_75216_d()) {
            ItemStack itemStack = slotUnderMouse.func_75211_c();
            guiContainer.func_146285_a(itemStack, event.mouseX, event.mouseY);
        }
    }

    @SubscribeEvent
    public void onClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (this.itemListOverlay == null || event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        GuiContainer guiContainer = this.asGuiContainer(minecraft.field_71462_r);
        if (guiContainer == null) {
            return;
        }
        this.itemListOverlay.handleTick();
    }

    @SubscribeEvent
    public void onGuiKeyboardEvent(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (!(event.gui instanceof GuiContainer)) {
            return;
        }
        if (this.inputHandler != null && this.inputHandler.handleKeyEvent()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiMouseEvent(GuiScreenEvent.MouseInputEvent.Pre event) {
        int y;
        int x;
        GuiScreen gui = event.gui;
        if (!(gui instanceof GuiContainer)) {
            return;
        }
        if (this.inputHandler != null && this.inputHandler.handleMouseEvent(x = Mouse.getEventX() * gui.field_146294_l / gui.field_146297_k.field_71443_c, y = gui.field_146295_m - Mouse.getEventY() * gui.field_146295_m / gui.field_146297_k.field_71440_d - 1)) {
            event.setCanceled(true);
        }
    }

    @Nullable
    private GuiContainer asGuiContainer(GuiScreen guiScreen) {
        if (!(guiScreen instanceof GuiContainer)) {
            return null;
        }
        return (GuiContainer)guiScreen;
    }
}

