/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.JeiHelpers;
import mezz.jei.RecipeRegistry;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import mezz.jei.gui.recipes.RecipeClickableArea;
import mezz.jei.plugins.jei.description.ItemDescriptionRecipe;
import mezz.jei.util.Log;
import mezz.jei.util.RecipeTransferRegistry;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class ModRegistry
implements IModRegistry {
    private final IJeiHelpers jeiHelpers;
    private final IIngredientRegistry ingredientRegistry;
    private final List<IRecipeCategory> recipeCategories = new ArrayList<IRecipeCategory>();
    private final List<IRecipeHandler> recipeHandlers = new ArrayList<IRecipeHandler>();
    private final List<IAdvancedGuiHandler<?>> advancedGuiHandlers = new ArrayList();
    private final List<Object> recipes = new ArrayList<Object>();
    private final RecipeTransferRegistry recipeTransferRegistry;
    private final Multimap<Class<? extends GuiContainer>, RecipeClickableArea> recipeClickableAreas = HashMultimap.create();
    private final Multimap<String, ItemStack> craftItemsForCategories = ArrayListMultimap.create();
    private final List<IRecipeRegistryPlugin> recipeRegistryPlugins = new ArrayList<IRecipeRegistryPlugin>();

    public ModRegistry(JeiHelpers jeiHelpers, IIngredientRegistry ingredientRegistry) {
        this.jeiHelpers = jeiHelpers;
        this.ingredientRegistry = ingredientRegistry;
        this.recipeTransferRegistry = new RecipeTransferRegistry(jeiHelpers.getStackHelper(), jeiHelpers.recipeTransferHandlerHelper());
    }

    @Override
    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }

    @Override
    public IIngredientRegistry getIngredientRegistry() {
        return this.ingredientRegistry;
    }

    @Override
    public void addRecipeCategories(IRecipeCategory ... recipeCategories) {
        if (recipeCategories != null) {
            Collections.addAll(this.recipeCategories, recipeCategories);
        }
    }

    @Override
    public void addRecipeHandlers(IRecipeHandler ... recipeHandlers) {
        if (recipeHandlers != null) {
            Collections.addAll(this.recipeHandlers, recipeHandlers);
        }
    }

    @Override
    public void addRecipes(@Nullable Collection recipes) {
        if (recipes != null) {
            this.recipes.addAll(recipes);
        }
    }

    @Override
    public void addRecipeClickArea(@Nullable Class<? extends GuiContainer> guiClass, int xPos, int yPos, int width, int height, String ... recipeCategoryUids) {
        if (guiClass == null) {
            NullPointerException e = new NullPointerException();
            Log.error("Tried to add a RecipeClickArea with null guiClass.", e);
            return;
        }
        if (recipeCategoryUids == null) {
            NullPointerException e = new NullPointerException();
            Log.error("Tried to add a RecipeClickArea with null recipeCategoryUids.", e);
            return;
        }
        if (recipeCategoryUids.length == 0) {
            NullPointerException e = new NullPointerException();
            Log.error("Tried to add a RecipeClickArea with empty list of recipeCategoryUids.", e);
            return;
        }
        RecipeClickableArea recipeClickableArea = new RecipeClickableArea(yPos, yPos + height, xPos, xPos + width, recipeCategoryUids);
        this.recipeClickableAreas.put(guiClass, (Object)recipeClickableArea);
    }

    @Override
    public void addRecipeCategoryCraftingItem(@Nullable ItemStack craftingItem, String ... recipeCategoryUids) {
        if (craftingItem == null) {
            NullPointerException e = new NullPointerException();
            Log.error("Tried to add a RecipeCategoryCraftingItem with null craftingItem.", e);
            return;
        }
        if (craftingItem.func_190926_b()) {
            Log.error("Tried to add a RecipeCategoryCraftingItem with empty craftingItem.", new IllegalArgumentException());
            return;
        }
        if (recipeCategoryUids == null) {
            NullPointerException e = new NullPointerException();
            Log.error("Tried to add a RecipeCategoryCraftingItem with null recipeCategoryUids.", e);
            return;
        }
        if (recipeCategoryUids.length == 0) {
            NullPointerException e = new NullPointerException();
            Log.error("Tried to add a RecipeCategoryCraftingItem with an empty list of recipeCategoryUids.", e);
            return;
        }
        for (String recipeCategoryUid : recipeCategoryUids) {
            if (recipeCategoryUid == null) {
                IllegalArgumentException e = new IllegalArgumentException();
                Log.error("Tried to add a RecipeCategoryCraftingItem with null recipeCategoryUid.", e);
                continue;
            }
            this.craftItemsForCategories.put((Object)recipeCategoryUid, (Object)craftingItem);
        }
    }

    @Override
    public void addAdvancedGuiHandlers(IAdvancedGuiHandler<?> ... advancedGuiHandlers) {
        if (advancedGuiHandlers != null) {
            Collections.addAll(this.advancedGuiHandlers, advancedGuiHandlers);
        }
    }

    @Override
    public void addDescription(@Nullable List<ItemStack> itemStacks, String ... descriptionKeys) {
        if (itemStacks == null || itemStacks.size() == 0) {
            IllegalArgumentException e = new IllegalArgumentException();
            Log.error("Tried to add description with no itemStacks.", e);
            return;
        }
        if (descriptionKeys == null) {
            IllegalArgumentException e = new IllegalArgumentException();
            Log.error("Tried to add a null descriptionKey for itemStacks {}.", itemStacks, e);
            return;
        }
        if (descriptionKeys.length == 0) {
            IllegalArgumentException e = new IllegalArgumentException();
            Log.error("Tried to add an empty list of descriptionKeys for itemStacks {}.", itemStacks, e);
            return;
        }
        IGuiHelper guiHelper = this.jeiHelpers.getGuiHelper();
        List<ItemDescriptionRecipe> recipes = ItemDescriptionRecipe.create(guiHelper, itemStacks, descriptionKeys);
        this.recipes.addAll(recipes);
    }

    @Override
    public void addDescription(@Nullable ItemStack itemStack, String ... descriptionKeys) {
        this.addDescription(Collections.singletonList(itemStack), descriptionKeys);
    }

    @Override
    public IRecipeTransferRegistry getRecipeTransferRegistry() {
        return this.recipeTransferRegistry;
    }

    @Override
    public void addRecipeRegistryPlugin(@Nullable IRecipeRegistryPlugin recipeRegistryPlugin) {
        if (recipeRegistryPlugin == null) {
            NullPointerException e = new NullPointerException();
            Log.error("Tried to add null recipeRegistryPlugin.", e);
            return;
        }
        Log.info("Added recipe registry plugin: {}", recipeRegistryPlugin.getClass());
        this.recipeRegistryPlugins.add(recipeRegistryPlugin);
    }

    public List<IAdvancedGuiHandler<?>> getAdvancedGuiHandlers() {
        return this.advancedGuiHandlers;
    }

    public RecipeRegistry createRecipeRegistry(IIngredientRegistry ingredientRegistry) {
        ImmutableTable<Class, String, IRecipeTransferHandler> recipeTransferHandlers = this.recipeTransferRegistry.getRecipeTransferHandlers();
        return new RecipeRegistry(this.recipeCategories, this.recipeHandlers, recipeTransferHandlers, this.recipes, this.recipeClickableAreas, this.craftItemsForCategories, ingredientRegistry, this.recipeRegistryPlugins);
    }
}

