/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Ingredients;
import mezz.jei.util.Log;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class ErrorUtil {
    public static <T> String getInfoFromBrokenRecipe(T recipe, IRecipeHandler<T> recipeHandler) {
        IRecipeWrapper recipeWrapper;
        StringBuilder recipeInfoBuilder = new StringBuilder();
        try {
            recipeInfoBuilder.append(recipe);
        }
        catch (RuntimeException e) {
            Log.error("Failed recipe.toString", e);
            recipeInfoBuilder.append(recipe.getClass());
        }
        try {
            recipeWrapper = recipeHandler.getRecipeWrapper(recipe);
        }
        catch (RuntimeException ignored) {
            recipeInfoBuilder.append("\nFailed to create recipe wrapper");
            return recipeInfoBuilder.toString();
        }
        catch (LinkageError ignored) {
            recipeInfoBuilder.append("\nFailed to create recipe wrapper");
            return recipeInfoBuilder.toString();
        }
        Ingredients ingredients = new Ingredients();
        try {
            recipeWrapper.getIngredients(ingredients);
        }
        catch (RuntimeException ignored) {
            recipeInfoBuilder.append("\nFailed to get ingredients from recipe wrapper");
            return recipeInfoBuilder.toString();
        }
        catch (LinkageError ignored) {
            recipeInfoBuilder.append("\nFailed to get ingredients from recipe wrapper");
            return recipeInfoBuilder.toString();
        }
        recipeInfoBuilder.append("\nOutputs:");
        Set<Class> outputClasses = ingredients.getOutputIngredients().keySet();
        for (Class outputClass : outputClasses) {
            List<String> ingredientOutputInfo = ErrorUtil.getIngredientOutputInfo(outputClass, ingredients);
            recipeInfoBuilder.append('\n').append(outputClass.getName()).append(": ").append(ingredientOutputInfo);
        }
        recipeInfoBuilder.append("\nInputs:");
        Set<Class> inputClasses = ingredients.getInputIngredients().keySet();
        for (Class inputClass : inputClasses) {
            List<String> ingredientInputInfo = ErrorUtil.getIngredientInputInfo(inputClass, ingredients);
            recipeInfoBuilder.append('\n').append(inputClass.getName()).append(": ").append(ingredientInputInfo);
        }
        return recipeInfoBuilder.toString();
    }

    private static <T> List<String> getIngredientOutputInfo(Class<T> ingredientClass, IIngredients ingredients) {
        IIngredientHelper<T> ingredientHelper = Internal.getIngredientRegistry().getIngredientHelper(ingredientClass);
        List<List<T>> outputs = ingredients.getOutputs(ingredientClass);
        return ErrorUtil.getIngredientInfo(ingredientHelper, outputs);
    }

    private static <T> List<String> getIngredientInputInfo(Class<T> ingredientClass, IIngredients ingredients) {
        IIngredientHelper<T> ingredientHelper = Internal.getIngredientRegistry().getIngredientHelper(ingredientClass);
        List<List<T>> inputs = ingredients.getInputs(ingredientClass);
        return ErrorUtil.getIngredientInfo(ingredientHelper, inputs);
    }

    private static <T> List<String> getIngredientInfo(IIngredientHelper<T> ingredientHelper, List<List<T>> ingredients) {
        ArrayList<String> allInfos = new ArrayList<String>(ingredients.size());
        for (List<T> inputList : ingredients) {
            ArrayList<String> infos = new ArrayList<String>(inputList.size());
            for (T input : inputList) {
                String errorInfo = ingredientHelper.getErrorInfo(input);
                infos.add(errorInfo);
            }
            allInfos.add(((Object)infos).toString());
        }
        return allInfos;
    }

    public static String getItemStackInfo(@Nullable ItemStack itemStack) {
        String itemName;
        if (itemStack == null) {
            return "null";
        }
        Item item = itemStack.func_77973_b();
        ResourceLocation registryName = item.getRegistryName();
        if (registryName != null) {
            itemName = registryName.toString();
        } else if (item instanceof ItemBlock) {
            ResourceLocation blockRegistryName;
            Block block = ((ItemBlock)item).func_179223_d();
            String blockName = block == null ? "null" : ((blockRegistryName = block.getRegistryName()) != null ? blockRegistryName.toString() : block.getClass().getName());
            itemName = "ItemBlock(" + blockName + ")";
        } else {
            itemName = item.getClass().getName();
        }
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt != null) {
            return itemStack + " " + itemName + " nbt:" + nbt;
        }
        return itemStack + " " + itemName;
    }
}

