/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Map;
import mezz.jei.util.ErrorUtil;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class CommandUtil {
    public static String[] getGiveCommandParameters(EntityPlayer sender, ItemStack itemStack, int amount) {
        String senderName = sender.func_70005_c_();
        Item item = itemStack.func_77973_b();
        ResourceLocation itemResourceLocation = item.getRegistryName();
        if (itemResourceLocation == null) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("item.getRegistryName() returned null for: " + stackInfo);
        }
        ArrayList<String> commandStrings = new ArrayList<String>();
        commandStrings.add(senderName);
        commandStrings.add(itemResourceLocation.toString());
        commandStrings.add(String.valueOf(amount));
        commandStrings.add(String.valueOf(itemStack.func_77960_j()));
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            commandStrings.add(tagCompound.toString());
        }
        return commandStrings.toArray(new String[commandStrings.size()]);
    }

    public static void writeChatMessage(EntityPlayer player, String translationKey, TextFormatting color) {
        TextComponentTranslation component = new TextComponentTranslation(translationKey, new Object[0]);
        component.func_150256_b().func_150238_a(color);
        player.func_145747_a((ITextComponent)component);
    }

    public static boolean hasPermission(EntityPlayerMP sender, ItemStack itemStack) {
        if (sender.func_184812_l_()) {
            return true;
        }
        MinecraftServer minecraftServer = sender.field_71133_b;
        ICommandManager commandManager = minecraftServer.func_71187_D();
        Map commands = commandManager.func_71555_a();
        ICommand giveCommand = (ICommand)commands.get("give");
        if (giveCommand != null && giveCommand.func_184882_a(minecraftServer, (ICommandSender)sender)) {
            String[] commandParameters = CommandUtil.getGiveCommandParameters((EntityPlayer)sender, itemStack, itemStack.func_190916_E());
            CommandEvent event = new CommandEvent(giveCommand, (ICommandSender)sender, commandParameters);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                Throwable exception = event.getException();
                if (exception != null) {
                    Throwables.propagateIfPossible((Throwable)exception);
                }
                return false;
            }
            return true;
        }
        return sender.func_70003_b(minecraftServer.func_110455_j(), "give");
    }

    public static void executeGive(EntityPlayer entityplayer, ItemStack itemStack) {
        EntityItem entityitem;
        boolean addedToInventory = entityplayer.field_71071_by.func_70441_a(itemStack);
        if (addedToInventory) {
            entityplayer.field_70170_p.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((entityplayer.func_70681_au().nextFloat() - entityplayer.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityplayer.field_71069_bz.func_75142_b();
        }
        if (!(addedToInventory && itemStack.func_190916_E() <= 0 || (entityitem = entityplayer.func_71019_a(itemStack, false)) == null)) {
            entityitem.func_174868_q();
            entityitem.func_145797_a(entityplayer.func_70005_c_());
        }
    }
}

