/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.furnace;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class SmeltingRecipe
extends BlankRecipeWrapper {
    private final List<List<ItemStack>> inputs;
    private final ItemStack output;

    public SmeltingRecipe(List<ItemStack> inputs, ItemStack output) {
        this.inputs = Collections.singletonList(inputs);
        this.output = output;
    }

    @Override
    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setOutput(ItemStack.class, this.output);
    }

    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public List<ItemStack> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
        float experience = furnaceRecipes.func_151398_b(this.output);
        if (experience > 0.0f) {
            String experienceString = Translator.translateToLocalFormatted("gui.jei.category.smelting.experience", Float.valueOf(experience));
            FontRenderer fontRendererObj = minecraft.field_71466_p;
            int stringWidth = fontRendererObj.func_78256_a(experienceString);
            fontRendererObj.func_78276_b(experienceString, recipeWidth - stringWidth, 0, Color.gray.getRGB());
        }
    }
}

