/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.crafting;

import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapelessRecipesWrapper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapelessRecipes;

public class ShapelessRecipesHandler
implements IRecipeHandler<ShapelessRecipes> {
    @Override
    public Class<ShapelessRecipes> getRecipeClass() {
        return ShapelessRecipes.class;
    }

    @Override
    public String getRecipeCategoryUid(ShapelessRecipes recipe) {
        return "minecraft.crafting";
    }

    @Override
    public IRecipeWrapper getRecipeWrapper(ShapelessRecipes recipe) {
        return new ShapelessRecipesWrapper(recipe);
    }

    @Override
    public boolean isRecipeValid(ShapelessRecipes recipe) {
        if (recipe.func_77571_b() == null) {
            String recipeInfo = ErrorUtil.getInfoFromBrokenRecipe(recipe, this);
            Log.error("Recipe has no output. {}", recipeInfo);
            return false;
        }
        int inputCount = 0;
        for (Object input : recipe.field_77579_b) {
            if (input instanceof ItemStack) {
                ++inputCount;
                continue;
            }
            String recipeInfo = ErrorUtil.getInfoFromBrokenRecipe(recipe, this);
            Log.error("Recipe has an input that is not an ItemStack. {}", recipeInfo);
            return false;
        }
        if (inputCount > 9) {
            String recipeInfo = ErrorUtil.getInfoFromBrokenRecipe(recipe, this);
            Log.error("Recipe has too many inputs. {}", recipeInfo);
            return false;
        }
        return inputCount > 0;
    }
}

