/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.google.common.collect.ArrayListMultimap;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.config.Constants;
import mezz.jei.gui.GuiHelper;
import mezz.jei.gui.GuiProperties;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IShowsRecipeFocuses;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class RecipeCategoryCraftingItems
implements IShowsRecipeFocuses {
    private final IDrawable topDrawable;
    private final IDrawable middleDrawable;
    private final IDrawable bottomDrawable;
    private GuiItemStackGroup craftingItems = new GuiItemStackGroup(null);
    private int left = 0;
    private int top = 0;

    public RecipeCategoryCraftingItems() {
        ResourceLocation recipeBackgroundResource = new ResourceLocation(Constants.RESOURCE_DOMAIN, "textures/gui/recipe_background.png");
        GuiHelper guiHelper = Internal.getHelpers().getGuiHelper();
        this.topDrawable = guiHelper.createDrawable(recipeBackgroundResource, 196, 65, 26, 6);
        this.middleDrawable = guiHelper.createDrawable(recipeBackgroundResource, 196, 71, 26, 16);
        this.bottomDrawable = guiHelper.createDrawable(recipeBackgroundResource, 196, 87, 26, 6);
    }

    public void updateLayout(List<ItemStack> itemStacks, GuiProperties guiProperties) {
        this.craftingItems = new GuiItemStackGroup(null);
        if (!itemStacks.isEmpty()) {
            int i;
            int totalHeight = this.topDrawable.getHeight() + this.middleDrawable.getHeight() + this.bottomDrawable.getHeight();
            int ingredientCount = 1;
            int extraBoxHeight = this.middleDrawable.getHeight();
            for (int i2 = 1; i2 < itemStacks.size() && totalHeight + extraBoxHeight <= guiProperties.getGuiYSize() - 8; ++i2) {
                totalHeight += extraBoxHeight;
                ++ingredientCount;
            }
            this.top = guiProperties.getGuiTop();
            this.left = guiProperties.getGuiLeft() - this.topDrawable.getWidth() + 4;
            ArrayListMultimap itemStacksForSlots = ArrayListMultimap.create();
            for (i = 0; i < itemStacks.size(); ++i) {
                ItemStack itemStack = itemStacks.get(i);
                if (i < ingredientCount) {
                    itemStacksForSlots.put((Object)i, (Object)itemStack);
                    continue;
                }
                int index = ingredientCount - i % ingredientCount;
                itemStacksForSlots.put((Object)index, (Object)itemStack);
            }
            for (i = 0; i < ingredientCount; ++i) {
                this.craftingItems.init(i, true, this.left + 5, this.top + 5 + i * this.middleDrawable.getHeight());
                List itemStacksForSlot = itemStacksForSlots.get((Object)i);
                this.craftingItems.set(i, itemStacksForSlot);
            }
        }
    }

    @Nullable
    public GuiIngredient<ItemStack> draw(Minecraft minecraft, int mouseX, int mouseY) {
        int ingredientCount = this.craftingItems.getGuiIngredients().keySet().size();
        if (ingredientCount > 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_179141_d();
            int top = this.top;
            this.topDrawable.draw(minecraft, this.left, top);
            top += this.topDrawable.getHeight();
            while (ingredientCount-- > 0) {
                this.middleDrawable.draw(minecraft, this.left, top);
                top += this.middleDrawable.getHeight();
            }
            this.bottomDrawable.draw(minecraft, this.left, top);
            GlStateManager.func_179118_c();
            GlStateManager.func_179126_j();
            return this.craftingItems.draw(minecraft, 0, 0, mouseX, mouseY);
        }
        return null;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        ItemStack ingredientUnderMouse = (ItemStack)this.craftingItems.getIngredientUnderMouse(0, 0, mouseX, mouseY);
        if (ingredientUnderMouse != null) {
            return new ClickedIngredient<ItemStack>(ingredientUnderMouse);
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return true;
    }
}

