/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.client.config.HoverChecker;

public class ShapelessIcon {
    private static final IDrawable icon = Internal.getHelpers().getGuiHelper().getShapelessIcon();
    private final HoverChecker hoverChecker;

    public ShapelessIcon() {
        int iconBottom = icon.getHeight() / 2;
        int iconLeft = 116 - ShapelessIcon.getWidth();
        int iconRight = iconLeft + ShapelessIcon.getWidth();
        this.hoverChecker = new HoverChecker(0, iconBottom, iconLeft, iconRight, 0);
    }

    public static int getWidth() {
        return icon.getWidth() / 2;
    }

    public static int getHeight() {
        return icon.getHeight() / 2;
    }

    public void draw(Minecraft minecraft, int recipeWidth) {
        int shapelessIconX = recipeWidth - ShapelessIcon.getWidth();
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        icon.draw(minecraft, shapelessIconX * 2, 0);
        GlStateManager.func_179121_F();
    }

    @Nullable
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (this.hoverChecker.checkHover(mouseX, mouseY)) {
            return Collections.singletonList(Translator.translateToLocal("jei.tooltip.shapeless.recipe"));
        }
        return null;
    }
}

