/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import javax.annotation.Nullable;
import mezz.jei.gui.recipes.RecipesGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;

public class GuiProperties {
    private final Class guiClass;
    private final int guiLeft;
    private final int guiTop;
    private final int guiXSize;
    private final int guiYSize;
    private final int screenWidth;
    private final int screenHeight;

    @Nullable
    public static GuiProperties create(GuiScreen guiScreen) {
        if (guiScreen instanceof RecipesGui) {
            return GuiProperties.create((RecipesGui)guiScreen);
        }
        if (guiScreen instanceof GuiContainer) {
            return GuiProperties.create((GuiContainer)guiScreen);
        }
        return null;
    }

    public static GuiProperties create(GuiContainer guiContainer) {
        return new GuiProperties(guiContainer.getClass(), guiContainer.getGuiLeft(), guiContainer.getGuiTop(), guiContainer.getXSize(), guiContainer.getYSize(), guiContainer.field_146294_l, guiContainer.field_146295_m);
    }

    public static GuiProperties create(RecipesGui recipesGui) {
        return new GuiProperties(recipesGui.getClass(), recipesGui.getGuiLeft(), recipesGui.getGuiTop(), recipesGui.getXSize(), recipesGui.getYSize(), recipesGui.field_146294_l, recipesGui.field_146295_m);
    }

    private GuiProperties(Class guiClass, int guiLeft, int guiTop, int guiXSize, int guiYSize, int screenWidth, int screenHeight) {
        this.guiClass = guiClass;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.guiXSize = guiXSize;
        this.guiYSize = guiYSize;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public Class getGuiClass() {
        return this.guiClass;
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    public int getGuiXSize() {
        return this.guiXSize;
    }

    public int getGuiYSize() {
        return this.guiYSize;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GuiProperties)) {
            return false;
        }
        GuiProperties other = (GuiProperties)obj;
        return this.guiClass == other.getGuiClass() && this.guiLeft == other.getGuiLeft() && this.guiXSize == other.getGuiXSize() && this.screenWidth == other.getScreenWidth() && this.screenHeight == other.getScreenHeight();
    }

    public int hashCode() {
        int result = this.guiClass.hashCode();
        result = 31 * result + this.guiLeft;
        result = 31 * result + this.guiXSize;
        result = 31 * result + this.screenWidth;
        result = 31 * result + this.screenHeight;
        return result;
    }
}

