/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.InternalRecipeRegistryPlugin;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.config.Config;
import mezz.jei.gui.Focus;
import mezz.jei.gui.recipes.RecipeClickableArea;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Ingredients;
import mezz.jei.util.Log;
import mezz.jei.util.RecipeCategoryComparator;
import mezz.jei.util.RecipeMap;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.ProgressManager;

public class RecipeRegistry
implements IRecipeRegistry {
    private final IIngredientRegistry ingredientRegistry;
    private final ImmutableList<IRecipeHandler> recipeHandlers;
    private final ImmutableList<IRecipeCategory> recipeCategories;
    private final ImmutableTable<Class, String, IRecipeTransferHandler> recipeTransferHandlers;
    private final ImmutableMultimap<Class<? extends GuiContainer>, RecipeClickableArea> recipeClickableAreasMap;
    private final ImmutableListMultimap<IRecipeCategory, ItemStack> craftItemsForCategories;
    private final ImmutableMap<String, IRecipeCategory> recipeCategoriesMap;
    private final ListMultimap<IRecipeCategory, Object> recipesForCategories = ArrayListMultimap.create();
    private final ListMultimap<IRecipeCategory, IRecipeWrapper> recipeWrappersForCategories = ArrayListMultimap.create();
    private final RecipeMap recipeInputMap;
    private final RecipeMap recipeOutputMap;
    private final Set<Class> unhandledRecipeClasses = new HashSet<Class>();
    private final List<IRecipeRegistryPlugin> plugins = new ArrayList<IRecipeRegistryPlugin>();

    public RecipeRegistry(List<IRecipeCategory> recipeCategories, List<IRecipeHandler> recipeHandlers, ImmutableTable<Class, String, IRecipeTransferHandler> recipeTransferHandlers, List<Object> recipes, Multimap<Class<? extends GuiContainer>, RecipeClickableArea> recipeClickableAreasMap, Multimap<String, ItemStack> craftItemsForCategories, IIngredientRegistry ingredientRegistry, List<IRecipeRegistryPlugin> plugins) {
        this.ingredientRegistry = ingredientRegistry;
        this.recipeCategoriesMap = RecipeRegistry.buildRecipeCategoriesMap(recipeCategories);
        this.recipeTransferHandlers = recipeTransferHandlers;
        this.recipeHandlers = RecipeRegistry.buildRecipeHandlersList(recipeHandlers);
        this.recipeClickableAreasMap = ImmutableMultimap.copyOf(recipeClickableAreasMap);
        RecipeCategoryComparator recipeCategoryComparator = new RecipeCategoryComparator(recipeCategories);
        this.recipeInputMap = new RecipeMap(recipeCategoryComparator, ingredientRegistry);
        this.recipeOutputMap = new RecipeMap(recipeCategoryComparator, ingredientRegistry);
        this.addRecipes(recipes);
        ImmutableListMultimap.Builder craftItemsForCategoriesBuilder = ImmutableListMultimap.builder();
        ImmutableMultimap.Builder categoriesForCraftItemKeysBuilder = ImmutableMultimap.builder();
        IIngredientHelper<ItemStack> ingredientHelper = ingredientRegistry.getIngredientHelper(ItemStack.class);
        for (Map.Entry recipeCategoryEntry : craftItemsForCategories.asMap().entrySet()) {
            String recipeCategoryUid = (String)recipeCategoryEntry.getKey();
            IRecipeCategory recipeCategory = (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
            if (recipeCategory == null) continue;
            Collection craftItems = (Collection)recipeCategoryEntry.getValue();
            craftItemsForCategoriesBuilder.putAll((Object)recipeCategory, (Iterable)craftItems);
            for (ItemStack craftItem : craftItems) {
                this.recipeInputMap.addRecipeCategory(recipeCategory, craftItem);
                String craftItemKey = ingredientHelper.getUniqueId(craftItem);
                categoriesForCraftItemKeysBuilder.put((Object)craftItemKey, (Object)recipeCategoryUid);
            }
        }
        this.craftItemsForCategories = craftItemsForCategoriesBuilder.build();
        ImmutableMultimap categoriesForCraftItemKeys = categoriesForCraftItemKeysBuilder.build();
        InternalRecipeRegistryPlugin internalRecipeRegistryPlugin = new InternalRecipeRegistryPlugin(this, (ImmutableMultimap<String, String>)categoriesForCraftItemKeys, ingredientRegistry, this.recipeCategoriesMap, this.recipeInputMap, this.recipeOutputMap, this.recipeWrappersForCategories);
        this.plugins.add(internalRecipeRegistryPlugin);
        this.plugins.addAll(plugins);
        ImmutableList.Builder recipeCategoryBuilder = ImmutableList.builder();
        for (IRecipeCategory recipeCategory : recipeCategories) {
            List recipeWrappers = this.getRecipeWrappers(recipeCategory);
            if (recipeWrappers.isEmpty()) continue;
            recipeCategoryBuilder.add((Object)recipeCategory);
        }
        this.recipeCategories = recipeCategoryBuilder.build();
    }

    private static ImmutableMap<String, IRecipeCategory> buildRecipeCategoriesMap(List<IRecipeCategory> recipeCategories) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (IRecipeCategory recipeCategory : recipeCategories) {
            mapBuilder.put((Object)recipeCategory.getUid(), (Object)recipeCategory);
        }
        return mapBuilder.build();
    }

    private static ImmutableList<IRecipeHandler> buildRecipeHandlersList(List<IRecipeHandler> recipeHandlers) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        HashSet recipeHandlerClasses = new HashSet();
        for (IRecipeHandler recipeHandler : recipeHandlers) {
            Class recipeClass;
            if (recipeHandler == null) continue;
            try {
                recipeClass = recipeHandler.getRecipeClass();
            }
            catch (RuntimeException e) {
                Log.error("Recipe handler crashed.", e);
                continue;
            }
            catch (LinkageError e) {
                Log.error("Recipe handler crashed.", e);
                continue;
            }
            if (recipeHandlerClasses.contains(recipeClass)) {
                Log.error("A Recipe Handler has already been registered for this recipe class: " + recipeClass.getName(), new Object[0]);
                continue;
            }
            recipeHandlerClasses.add(recipeClass);
            listBuilder.add((Object)recipeHandler);
        }
        return listBuilder.build();
    }

    private void addRecipes(@Nullable List<Object> recipes) {
        if (recipes == null) {
            return;
        }
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Adding recipes", (int)recipes.size());
        for (Object recipe : recipes) {
            progressBar.step("");
            this.addRecipe(recipe);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    @Override
    public <V> IFocus<V> createFocus(@Nullable IFocus.Mode mode, @Nullable V ingredient) {
        if (mode == null) {
            throw new NullPointerException("Null mode");
        }
        if (ingredient == null) {
            throw new NullPointerException("Null ingredient");
        }
        return new Focus<V>(mode, ingredient);
    }

    @Override
    public void addRecipe(@Nullable Object recipe) {
        if (recipe == null) {
            Log.error("Null recipe", new NullPointerException());
            return;
        }
        this.addRecipe(recipe, recipe.getClass());
    }

    private <T> void addRecipe(T recipe, Class<? extends T> recipeClass) {
        IRecipeHandler<T> recipeHandler = this.getRecipeHandler(recipeClass);
        if (recipeHandler == null) {
            if (!this.unhandledRecipeClasses.contains(recipeClass)) {
                this.unhandledRecipeClasses.add(recipeClass);
                if (Config.isDebugModeEnabled()) {
                    Log.debug("Can't handle recipe: {}", recipeClass);
                }
            }
            return;
        }
        String recipeCategoryUid = recipeHandler.getRecipeCategoryUid(recipe);
        IRecipeCategory recipeCategory = (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
        if (recipeCategory == null) {
            Log.error("No recipe category registered for recipeCategoryUid: {}", recipeCategoryUid);
            return;
        }
        try {
            if (!recipeHandler.isRecipeValid(recipe)) {
                return;
            }
        }
        catch (RuntimeException e) {
            Log.error("Recipe check crashed", e);
            return;
        }
        catch (LinkageError e) {
            Log.error("Recipe check crashed", e);
            return;
        }
        try {
            this.addRecipeUnchecked(recipe, recipeCategory, recipeHandler);
        }
        catch (RuntimeException e) {
            String recipeInfo = ErrorUtil.getInfoFromBrokenRecipe(recipe, recipeHandler);
            Log.error("Found a broken recipe: {}\n", recipeInfo, e);
        }
        catch (LinkageError e) {
            String recipeInfo = ErrorUtil.getInfoFromBrokenRecipe(recipe, recipeHandler);
            Log.error("Found a broken recipe: {}\n", recipeInfo, e);
        }
    }

    private <T> void addRecipeUnchecked(T recipe, IRecipeCategory recipeCategory, IRecipeHandler<T> recipeHandler) {
        IRecipeWrapper recipeWrapper = recipeHandler.getRecipeWrapper(recipe);
        Ingredients ingredients = new Ingredients();
        recipeWrapper.getIngredients(ingredients);
        this.recipeInputMap.addRecipe(recipe, recipeCategory, recipeHandler, ingredients.getInputIngredients());
        this.recipeOutputMap.addRecipe(recipe, recipeCategory, recipeHandler, ingredients.getOutputIngredients());
        this.recipesForCategories.put((Object)recipeCategory, recipe);
        this.recipeWrappersForCategories.put((Object)recipeCategory, (Object)recipeWrapper);
    }

    @Override
    public List<IRecipeCategory> getRecipeCategories() {
        return this.recipeCategories;
    }

    public ImmutableList<IRecipeCategory> getRecipeCategories(@Nullable List<String> recipeCategoryUids) {
        if (recipeCategoryUids == null) {
            Log.error("Null recipeCategoryUids", new NullPointerException());
            return ImmutableList.of();
        }
        HashSet<String> uniqueUids = new HashSet<String>();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String recipeCategoryUid : recipeCategoryUids) {
            if (uniqueUids.contains(recipeCategoryUid)) continue;
            uniqueUids.add(recipeCategoryUid);
            IRecipeCategory recipeCategory = (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
            if (recipeCategory == null || this.getRecipeWrappers(recipeCategory).isEmpty()) continue;
            builder.add((Object)recipeCategory);
        }
        return builder.build();
    }

    @Override
    @Nullable
    public <T> IRecipeHandler<T> getRecipeHandler(@Nullable Class<? extends T> recipeClass) {
        if (recipeClass == null) {
            Log.error("Null recipeClass", new NullPointerException());
            return null;
        }
        for (IRecipeHandler recipeHandler : this.recipeHandlers) {
            if (!recipeHandler.getRecipeClass().equals(recipeClass)) continue;
            return recipeHandler;
        }
        for (IRecipeHandler recipeHandler : this.recipeHandlers) {
            if (!recipeHandler.getRecipeClass().isAssignableFrom(recipeClass)) continue;
            return recipeHandler;
        }
        return null;
    }

    @Nullable
    public RecipeClickableArea getRecipeClickableArea(GuiContainer gui, int mouseX, int mouseY) {
        ImmutableCollection recipeClickableAreas = this.recipeClickableAreasMap.get(gui.getClass());
        for (RecipeClickableArea recipeClickableArea : recipeClickableAreas) {
            if (!recipeClickableArea.checkHover(mouseX, mouseY)) continue;
            return recipeClickableArea;
        }
        return null;
    }

    @Nullable
    private static FluidStack getFluidFromItemBlock(IFocus<?> focus) {
        Block block;
        Fluid fluid;
        ItemStack itemStack;
        Item item;
        Object ingredient = focus.getValue();
        if (ingredient instanceof ItemStack && (item = (itemStack = (ItemStack)ingredient).func_77973_b()) instanceof ItemBlock && (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = ((ItemBlock)item).func_179223_d()))) != null) {
            return new FluidStack(fluid, 1000);
        }
        return null;
    }

    @Override
    public <V> List<IRecipeCategory> getRecipeCategories(@Nullable IFocus<V> focus) {
        if (focus == null) {
            Log.error("Null focus", new NullPointerException());
            return ImmutableList.of();
        }
        FluidStack fluidStack = RecipeRegistry.getFluidFromItemBlock(focus);
        if (fluidStack != null) {
            return this.getRecipeCategories(this.createFocus(focus.getMode(), fluidStack));
        }
        ArrayList<String> allRecipeCategoryUids = new ArrayList<String>();
        for (IRecipeRegistryPlugin plugin : this.plugins) {
            long start_time = System.currentTimeMillis();
            List<String> recipeCategoryUids = plugin.getRecipeCategoryUids(focus);
            long timeElapsed = System.currentTimeMillis() - start_time;
            if (timeElapsed > 10L) {
                Log.warning("Recipe Category lookup is slow: {} ms. {}", timeElapsed, plugin.getClass());
            }
            allRecipeCategoryUids.addAll(recipeCategoryUids);
        }
        return this.getRecipeCategories(allRecipeCategoryUids);
    }

    @Override
    public <T extends IRecipeWrapper, V> List<T> getRecipeWrappers(@Nullable IRecipeCategory<T> recipeCategory, @Nullable IFocus<V> focus) {
        if (recipeCategory == null) {
            Log.error("Null recipeCategory", new NullPointerException());
            return ImmutableList.of();
        }
        if (focus == null) {
            Log.error("Null focus", new NullPointerException());
            return ImmutableList.of();
        }
        FluidStack fluidStack = RecipeRegistry.getFluidFromItemBlock(focus);
        if (fluidStack != null) {
            return this.getRecipeWrappers(recipeCategory, this.createFocus(focus.getMode(), fluidStack));
        }
        ArrayList<T> allRecipeWrappers = new ArrayList<T>();
        for (IRecipeRegistryPlugin plugin : this.plugins) {
            long start_time = System.currentTimeMillis();
            List<T> recipeWrappers = plugin.getRecipeWrappers(recipeCategory, focus);
            long timeElapsed = System.currentTimeMillis() - start_time;
            if (timeElapsed > 10L) {
                Log.warning("Recipe Wrapper lookup is slow: {} ms. {}", timeElapsed, plugin.getClass());
            }
            allRecipeWrappers.addAll(recipeWrappers);
        }
        return allRecipeWrappers;
    }

    @Override
    public <T extends IRecipeWrapper> List<T> getRecipeWrappers(@Nullable IRecipeCategory<T> recipeCategory) {
        if (recipeCategory == null) {
            Log.error("Null recipeCategory", new NullPointerException());
            return ImmutableList.of();
        }
        ArrayList<T> allRecipeWrappers = new ArrayList<T>();
        for (IRecipeRegistryPlugin plugin : this.plugins) {
            long start_time = System.currentTimeMillis();
            List<T> recipeWrappers = plugin.getRecipeWrappers(recipeCategory);
            long timeElapsed = System.currentTimeMillis() - start_time;
            if (timeElapsed > 10L) {
                Log.warning("Recipe Wrapper lookup is slow: {} ms. {}", timeElapsed, plugin.getClass());
            }
            allRecipeWrappers.addAll(recipeWrappers);
        }
        return allRecipeWrappers;
    }

    @Override
    public List<ItemStack> getCraftingItems(IRecipeCategory recipeCategory, @Nullable IFocus focus) {
        Object ingredient;
        ImmutableList craftingItems = this.craftItemsForCategories.get((Object)recipeCategory);
        if (focus != null && focus.getMode() == IFocus.Mode.INPUT && (ingredient = focus.getValue()) instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)ingredient;
            IIngredientHelper<ItemStack> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ItemStack.class);
            ItemStack matchingStack = ingredientHelper.getMatch((Iterable<ItemStack>)craftingItems, itemStack);
            if (matchingStack != null) {
                return Collections.singletonList(matchingStack);
            }
        }
        return craftingItems;
    }

    @Override
    @Nullable
    public IRecipeTransferHandler getRecipeTransferHandler(@Nullable Container container, @Nullable IRecipeCategory recipeCategory) {
        if (container == null) {
            Log.error("Null container", new NullPointerException());
            return null;
        }
        if (recipeCategory == null) {
            Log.error("Null recipeCategory", new NullPointerException());
            return null;
        }
        Class<?> containerClass = container.getClass();
        IRecipeTransferHandler recipeTransferHandler = (IRecipeTransferHandler)this.recipeTransferHandlers.get(containerClass, (Object)recipeCategory.getUid());
        if (recipeTransferHandler != null) {
            return recipeTransferHandler;
        }
        return (IRecipeTransferHandler)this.recipeTransferHandlers.get(containerClass, (Object)"universal recipe transfer handler");
    }

    @Override
    public <T extends IRecipeWrapper> IRecipeLayoutDrawable createRecipeLayoutDrawable(IRecipeCategory<T> recipeCategory, T recipeWrapper, IFocus focus) {
        return new RecipeLayout(-1, recipeCategory, recipeWrapper, focus);
    }
}

