/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import com.google.common.base.Joiner;
import java.awt.Color;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.util.color.ColorNamer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import net.minecraft.util.text.TextFormatting;

public class IngredientInformation {
    @Nullable
    private static Language previousLanguage;
    private static Map<Object, String> tooltipCache;
    private static Map<Object, String> colorCache;

    public static <T> String getTooltipString(T ingredient, IIngredientRenderer<T> ingredientRenderer, String modId, String modName, String displayName) {
        String tooltipString = tooltipCache.get(ingredient);
        if (tooltipString == null) {
            List<String> tooltip = ingredientRenderer.getTooltip(Minecraft.func_71410_x(), ingredient);
            tooltipString = Joiner.on((char)' ').join(tooltip).toLowerCase();
            tooltipString = IngredientInformation.removeChatFormatting(tooltipString);
            tooltipString = tooltipString.replace(modId, "");
            tooltipString = tooltipString.replace(modName, "");
            tooltipString = tooltipString.replace(displayName, "");
            tooltipCache.put(ingredient, tooltipString);
        }
        return tooltipString;
    }

    private static String removeChatFormatting(String string) {
        String withoutFormattingCodes = TextFormatting.func_110646_a((String)string);
        return withoutFormattingCodes == null ? string : withoutFormattingCodes;
    }

    public static <V> String getColorString(V ingredient, IIngredientHelper<V> ingredientHelper) {
        String colorString = colorCache.get(ingredient);
        if (colorString == null) {
            Iterable<Color> colors = ingredientHelper.getColors(ingredient);
            ColorNamer colorNamer = Internal.getColorNamer();
            Collection<String> colorNames = colorNamer.getColorNames(colors);
            colorString = Joiner.on((char)' ').join(colorNames).toLowerCase();
            colorCache.put(ingredient, colorString);
        }
        return colorString;
    }

    public static void onStart(boolean resourceReload) {
        Language language = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        if (previousLanguage != null && !previousLanguage.equals((Object)language)) {
            tooltipCache.clear();
        }
        previousLanguage = language;
        if (resourceReload) {
            colorCache.clear();
        }
    }

    static {
        tooltipCache = new IdentityHashMap<Object, String>();
        colorCache = new IdentityHashMap<Object, String>();
    }
}

